/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.Action;

public class Return
extends Action {
    protected String eventName;
    protected Vector nameList;

    public Return(String eventName) {
        if (eventName == null) {
            throw new IllegalArgumentException("Event name cannot be null.");
        }
        this.init(eventName, null);
    }

    public Return(String[] names) {
        if (names == null) {
            throw new IllegalArgumentException("Name list cannot be null.");
        }
        this.init(null, names);
    }

    private void init(String eventName, String[] names) {
        if (eventName != null && eventName.equals("")) {
            throw new IllegalArgumentException("Event name cannot be empty.");
        }
        this.eventName = eventName;
        this.nameList = new Vector();
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.nameList.addElement(names[i]);
                ++i;
            }
        }
    }

    public String getEventName() {
        return this.eventName;
    }

    public String[] getNameList() {
        String[] ret = new String[this.nameList.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)this.nameList.elementAt(i);
            ++i;
        }
        return ret;
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        if (this.nameList.size() > 0) {
            out.print(" namelist='");
            int i = 0;
            while (i < this.nameList.size()) {
                if (i != 0) {
                    out.print(" ");
                }
                out.print(XMLUtilities.encodeAttribute((String)((String)this.nameList.elementAt(i))));
                ++i;
            }
            out.print("'");
        } else {
            out.print(" eventexpr='");
            out.print(XMLUtilities.encodeAttribute((String)this.eventName));
            out.print("'");
        }
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<return");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println("/>");
    }
}

