/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.vtp.framework.util.HashtableUtilities;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.WidgetDocument;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.Script;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;
import org.eclipse.vtp.framework.widgets.vxml.Variable;

public class VXMLDocument
extends VXMLWidget
implements WidgetDocument {
    protected String version;
    protected String applicationURI = null;
    protected Vector variables;
    protected Vector dialogs;
    protected Hashtable properties;
    protected Vector scripts;
    protected Vector eventHandlers;

    public VXMLDocument() {
        this.init("2.0");
    }

    public VXMLDocument(String version) {
        this.init(version);
    }

    private void init(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null.");
        }
        this.version = version;
        this.variables = new Vector();
        this.dialogs = new Vector();
        this.properties = new Hashtable();
        this.scripts = new Vector();
        this.eventHandlers = new Vector();
    }

    public void setApplicationURI(String applicationURI) {
        this.applicationURI = applicationURI;
    }

    public void addVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Cannot add null variable.");
        }
        this.variables.addElement(variable);
    }

    public void addDialog(Dialog dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException("Cannot add null dialog.");
        }
        this.dialogs.addElement(dialog);
    }

    public String getProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        return (String)this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        this.properties.put(key, value);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null.");
        }
        this.version = version;
    }

    public void addScript(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("Cannot add null script.");
        }
        this.scripts.addElement(script);
    }

    public void addEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Cannot add null event handler.");
        }
        this.eventHandlers.addElement(eventHandler);
    }

    public void writeDocument(PrintStream out) throws IOException {
        out.println("<?xml version=\"1.0\" ?>");
        this.writeWidget(out, 0);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        out.print(" version='");
        out.print(XMLUtilities.encodeAttribute((String)this.version));
        out.print("'");
        out.print(" xmlns='http://www.w3.org/2001/vxml'");
        if (this.applicationURI != null) {
            out.print(" application='" + this.applicationURI + "'");
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        String[] keys = HashtableUtilities.getKeys((Hashtable)this.properties);
        int i = 0;
        while (i < keys.length) {
            String value = (String)this.properties.get(keys[i]);
            out.println("<property name='" + keys[i] + "' value='" + value + "'/>");
            ++i;
        }
        i = 0;
        while (i < this.variables.size()) {
            ((Variable)this.variables.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.scripts.size()) {
            ((Script)this.scripts.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.dialogs.size()) {
            ((Dialog)this.dialogs.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</vxml>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<vxml");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }

    protected void writeEventHandlers(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.eventHandlers.size()) {
            ((EventHandler)this.eventHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }
}

