/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.localdata.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroup;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalVendor;

public class LocalModuleGroup
implements ILocalModuleGroup {
    private String id;
    private String name;
    private List versions;
    private LocalVendor vendor;

    public LocalModuleGroup(String id, String name) {
        this.id = id;
        this.name = name;
        this.versions = new ArrayList();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void addVersion(LocalModuleGroupVersion moduleGroupVersion) {
        this.versions.add(moduleGroupVersion);
        moduleGroupVersion.setModuleGroup(this);
    }

    public ILocalModuleGroupVersion getVersionByNumber(String versionNumber) {
        Iterator i = this.versions.iterator();
        while (i.hasNext()) {
            ILocalModuleGroupVersion lv = (ILocalModuleGroupVersion)i.next();
            if (!lv.getVersionNumber().equalsIgnoreCase(versionNumber)) continue;
            return lv;
        }
        return null;
    }

    public List getVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    public ILocalVendor getVendor() {
        return this.vendor;
    }

    protected void setVendor(LocalVendor vendor) {
        this.vendor = vendor;
    }
}

