/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.localdata.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vtp.desktop.core.localdata.ILocalModule;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroup;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalModule;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalModuleGroup;
import org.osgi.framework.Bundle;

public class LocalModuleGroupVersion
implements ILocalModuleGroupVersion {
    private String id;
    private String versionNumber;
    private List modules;
    private LocalModuleGroup moduleGroup;
    private Bundle bundle;

    public LocalModuleGroupVersion(String id, String versionNumber, Bundle bundle) {
        this.id = id;
        this.versionNumber = versionNumber;
        this.modules = new ArrayList();
        this.bundle = bundle;
    }

    public String getId() {
        return this.id;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void addModule(LocalModule module) {
        this.modules.add(module);
        module.setModuleGroupVersion(this);
    }

    public ILocalModule getModuleByName(String moduleName) {
        Iterator i = this.modules.iterator();
        while (i.hasNext()) {
            ILocalModule lv = (ILocalModule)i.next();
            if (!lv.getName().equalsIgnoreCase(moduleName)) continue;
            return lv;
        }
        return null;
    }

    public List getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    public ILocalModuleGroup getModuleGroup() {
        return this.moduleGroup;
    }

    protected void setModuleGroup(LocalModuleGroup moduleGroup) {
        this.moduleGroup = moduleGroup;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

