/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import org.eclipse.core.resources.IFolder;
import org.eclipse.vtp.desktop.core.project.IBinding;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.core.project.IBrandSet;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.IPromptSet;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.internals.Binding;
import org.eclipse.vtp.desktop.core.project.internals.BrandSet;
import org.eclipse.vtp.desktop.core.project.internals.MediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.internals.PromptSet;
import org.eclipse.vtp.desktop.core.project.internals.VoiceResource;

public class Brand
extends VoiceResource
implements IBrand {
    IFolder brandRoot;
    BrandSet brandSet;

    public Brand(IFolder brandRoot, BrandSet brandSet) {
        this.brandRoot = brandRoot;
        this.brandSet = brandSet;
        this.activateEvents();
    }

    public IBrandSet getBrandSet() {
        return this.brandSet;
    }

    public IMediaFilesFolder getMediaFilesFolder() {
        IFolder f = this.brandRoot.getFolder("Media Files");
        if (!f.exists()) {
            throw new RuntimeException("Media Files is missing");
        }
        return new MediaFilesFolder(this, f);
    }

    public IPromptSet getPromptSet() {
        return new PromptSet(this.brandRoot.getFile("Prompts.xml"), this);
    }

    public IBinding getBinding() {
        return new Binding(this.brandRoot.getFile(".binding"), this);
    }

    public String getName() {
        return this.brandRoot.getName();
    }

    public IVoiceResource getParent() {
        return this.brandSet;
    }

    protected String getObjectId() {
        return this.brandRoot.getFullPath().toPortableString();
    }
}

