/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.core.project.IBrandSet;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.internals.ApplicationProject;
import org.eclipse.vtp.desktop.core.project.internals.Brand;
import org.eclipse.vtp.desktop.core.project.internals.VoiceResource;

public class BrandSet
extends VoiceResource
implements IBrandSet {
    private ApplicationProject project;
    private IFolder folder;

    public BrandSet(ApplicationProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
        this.activateEvents();
    }

    public String getName() {
        return this.folder.getName();
    }

    public List getBrands() throws CoreException {
        ArrayList<Brand> brands = new ArrayList<Brand>();
        IResource[] res = this.folder.members();
        int i = 0;
        while (i < res.length) {
            if (!res[i].getName().startsWith(".")) {
                if (res[i].getType() == 2) {
                    // empty if block
                }
                brands.add(new Brand((IFolder)res[i], this));
            }
            ++i;
        }
        return brands;
    }

    public IBrand getBrand(String name) {
        return new Brand(this.folder.getFolder(name), this);
    }

    public void removeBrand(String name) throws CoreException {
        IFolder f = this.folder.getFolder(name);
        if (f.exists()) {
            f.delete(false, true, null);
        }
    }

    public IVoiceResource getParent() {
        return this.project;
    }

    public IBrand createBrand(String name) throws CoreException {
        DesktopCorePlugin.initializeBrandStructure(this.folder, name);
        IFolder f = this.folder.getFolder(name);
        return new Brand(f, this);
    }

    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }
}

