/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.core.project.IDatabase;
import org.eclipse.vtp.desktop.core.project.IDatabaseTable;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.internals.DatabaseSet;
import org.eclipse.vtp.desktop.core.project.internals.DatabaseTable;
import org.eclipse.vtp.desktop.core.project.internals.VoiceResource;

public class Database
extends VoiceResource
implements IDatabase {
    private static final String tableTemplate = "<database-table name=\"[name]\"><columns></columns></database-table>";
    DatabaseSet databaseSet;
    IFolder folder;
    String name;

    public Database(DatabaseSet databaseSet, IFolder folder) {
        this.databaseSet = databaseSet;
        this.folder = folder;
        this.name = folder.getName();
        this.activateEvents();
    }

    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    public String getName() {
        return this.name;
    }

    public List getTables() {
        ArrayList<DatabaseTable> ret = new ArrayList<DatabaseTable>();
        try {
            IResource[] res = this.folder.members();
            int i = 0;
            while (i < res.length) {
                IFile file;
                if (res[i] instanceof IFile && (file = (IFile)res[i]).getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("xml")) {
                    DatabaseTable table = new DatabaseTable(this, file);
                    ret.add(table);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public IVoiceResource getParent() {
        return this.databaseSet;
    }

    public IDatabaseTable createTable(String name) throws CoreException {
        IFile databaseTableFile = this.folder.getFile(String.valueOf(name) + ".xml");
        if (databaseTableFile.exists()) {
            throw new IllegalArgumentException("A Database table with that name already exists: " + name);
        }
        String template = new String(tableTemplate);
        template = template.replaceAll("\\[name\\]", name);
        databaseTableFile.create((InputStream)new ByteArrayInputStream(template.toString().getBytes()), true, null);
        DatabaseTable database = new DatabaseTable(this, databaseTableFile);
        return database;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Database) {
            return ((Database)obj).name.equals(this.name);
        }
        return false;
    }
}

