/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IDependency;
import org.eclipse.vtp.desktop.core.project.IDependencySet;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.core.project.internals.Dependency;
import org.eclipse.vtp.desktop.core.project.internals.VoiceResource;

public class DependencySet
extends VoiceResource
implements IDependencySet {
    private final IApplicationProject project;
    private final IFolder folder;

    public DependencySet(IApplicationProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
    }

    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    public String getName() {
        return this.folder.getName();
    }

    public IVoiceResource getParent() {
        return this.project;
    }

    public List getDependencies() {
        LinkedList<Dependency> results = new LinkedList<Dependency>();
        try {
            IResource[] members = this.folder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i].getType() == 1) {
                    results.add(new Dependency(this, (IFile)members[i]));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return results;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDependency createDependency(String name, URL content) {
        IFile file = this.folder.getFile(name);
        InputStream in = null;
        try {
            try {
                in = content.openStream();
                file.setContents(in, true, false, null);
            }
            catch (IOException e) {
                block11: {
                    e.printStackTrace();
                    break block11;
                    catch (CoreException e2) {
                        e2.printStackTrace();
                    }
                }
                Object var6_7 = null;
                try {
                    if (in == null) return null;
                    in.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {}
            catch (IOException iOException) {}
            if (in == null) throw throwable;
            in.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (in != null) {
            in.close();
        }
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
        return new Dependency(this, file);
    }

    public void removeDependency(IDependency dependency) {
        IFile file = this.folder.getFile(dependency.getName());
        try {
            if (file.exists()) {
                file.delete(true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
    }
}

