/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.internals.AudioFile;
import org.eclipse.vtp.desktop.core.project.internals.MediaFilesFolder;
import org.eclipse.vtp.framework.media.files.MediaDirectory;
import org.eclipse.vtp.framework.media.files.MediaFile;
import org.eclipse.vtp.framework.media.files.MediaFiles;
import org.eclipse.vtp.framework.media.files.MediaObject;
import org.eclipse.vtp.framework.media.xml.MediaXML;

public class AlternateTextManager {
    private static AlternateTextManager instance = new AlternateTextManager();
    private WeakHashMap descriptorMap = new WeakHashMap();

    public static AlternateTextManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlternateText(AudioFile audioFile) {
        String id;
        IVoiceResource r = audioFile.getParent();
        while (!(r instanceof MediaFilesFolder)) {
            r = r.getParent();
        }
        MediaFilesFolder mff = (MediaFilesFolder)r;
        IFile f = mff.getAlternateTextFile();
        String string = id = mff.getObjectId().intern();
        synchronized (string) {
            MediaFiles obj = null;
            WeakHashMap weakHashMap = this.descriptorMap;
            synchronized (weakHashMap) {
                obj = (MediaFiles)this.descriptorMap.get(id);
            }
            if (obj == null) {
                try {
                    obj = MediaXML.loadFiles((Source)new StreamSource(f.getContents()));
                    weakHashMap = this.descriptorMap;
                    synchronized (weakHashMap) {
                        this.descriptorMap.put(id, obj);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (obj != null) {
                MediaFiles mediaFiles = obj;
                MediaFile mediaFile = (MediaFile)mediaFiles.find(audioFile.getMediaPath());
                String string2 = mediaFile == null ? "" : mediaFile.getAlternateText();
                return string2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlternateText(AudioFile audioFile, String text) {
        String id;
        IVoiceResource r = audioFile.getParent();
        while (!(r instanceof MediaFilesFolder)) {
            r = r.getParent();
        }
        MediaFilesFolder mff = (MediaFilesFolder)r;
        IFile f = mff.getAlternateTextFile();
        String string = id = mff.getObjectId().intern();
        synchronized (string) {
            MediaFiles obj = null;
            WeakHashMap weakHashMap = this.descriptorMap;
            synchronized (weakHashMap) {
                this.descriptorMap.get(id);
            }
            if (obj == null) {
                try {
                    obj = MediaXML.loadFiles((Source)new StreamSource(f.getContents()));
                    weakHashMap = this.descriptorMap;
                    synchronized (weakHashMap) {
                        this.descriptorMap.put(id, obj);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (obj != null) {
                MediaFiles mediaFiles = obj;
                String mediaPath = audioFile.getMediaPath();
                MediaFile mediaFile = (MediaFile)mediaFiles.find(mediaPath);
                if (mediaFile == null) {
                    mediaFile = new MediaFile(audioFile.getName());
                    MediaFiles container = mediaFiles;
                    StringTokenizer st = new StringTokenizer(mediaPath, "/\\");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (!st.hasMoreElements()) continue;
                        MediaDirectory dir = (MediaDirectory)container.get(token);
                        if (dir == null) {
                            dir = new MediaDirectory(token);
                            container.add((MediaObject)dir);
                        }
                        container = dir;
                    }
                    container.add((MediaObject)mediaFile);
                }
                mediaFile.setAlternateText(text);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    MediaXML.saveFiles((MediaFiles)mediaFiles, (Result)new StreamResult(baos));
                    f.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), false, false, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

