/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.http;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.vtp.framework.kernel.api.CallManager;
import org.eclipse.vtp.framework.kernel.core.DefaultCallManager;
import org.eclipse.vtp.framework.kernel.core.KernelRegistry;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.widgets.WidgetDocument;

public class HTTPConnector
extends HttpServlet {
    private static final String KERNEL_CALL_ID = "KERNEL_CALL_ID";
    private static final String DEFAULT_BRAND = "Default";
    private static final String SLASH = "/";
    private static final String MIME_TYPE_TEXT_XML = "text/xml";
    private static final long serialVersionUID = 1L;
    private CallManager callManager = null;
    static /* synthetic */ Class class$0;

    public HTTPConnector() {
    }

    public HTTPConnector(KernelRegistry registry) {
        this.callManager = new DefaultCallManager(registry);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.callManager == null) {
            KernelRegistry registry;
            ServletContext servletContext = config.getServletContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.vtp.framework.kernel.core.KernelRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((registry = (KernelRegistry)servletContext.getAttribute(clazz.getName())) == null) {
                throw new ServletException("No kernel registry configured");
            }
            this.callManager = new DefaultCallManager(registry);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Object var11_16;
            WidgetDocument document = null;
            String callId = "";
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                try {
                    List items = upload.parseRequest(request);
                    int i = 0;
                    while (i < items.size()) {
                        FileItem fui = (FileItem)items.get(i);
                        if (fui.isFormField()) {
                            parameterMap.put(fui.getFieldName(), new String[]{fui.getString()});
                        } else {
                            File temp = File.createTempFile(Guid.createGUID(), ".wav");
                            fui.write(temp);
                            parameterMap.put(fui.getFieldName(), new String[]{temp.getAbsolutePath()});
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    parameterMap.put(key, request.getParameterValues(key));
                }
            }
            callId = this.getSingleRequestString(parameterMap, KERNEL_CALL_ID);
            String brand = request.getPathInfo();
            if (brand != null) {
                while (brand.startsWith(SLASH)) {
                    brand = brand.substring(1);
                }
                while (brand.endsWith(SLASH)) {
                    brand = brand.substring(0, brand.length() - 1);
                }
            }
            if (brand == null || brand.length() == 0) {
                brand = DEFAULT_BRAND;
            }
            parameterMap.put("BRAND", new String[]{brand});
            parameterMap.put("KERNEL_CONTEXT_PATH", new String[]{this.findContextPath(request)});
            try {
                document = callId == null || callId.length() == 0 ? this.callManager.initializeCall(parameterMap) : this.callManager.continueCall(callId, parameterMap);
            }
            catch (Throwable t) {
                this.getServletContext().log("Failed to process call: " + t.getMessage(), t);
                response.sendError(500, t.getMessage());
                t.printStackTrace();
                return;
            }
            if (document == null) {
                this.getServletContext().log("No VXML output generated");
                response.sendError(500);
                return;
            }
            response.setContentType(MIME_TYPE_TEXT_XML);
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Pragma", "no-store");
            response.addHeader("Pragma", "max-age=0");
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
            response.addHeader("Cache-Control", "max-age=0");
            ServletOutputStream out = null;
            try {
                out = response.getOutputStream();
                PrintStream ps = new PrintStream((OutputStream)out);
                document.writeDocument(ps);
                document.writeDocument(System.out);
                ps.flush();
            }
            catch (Throwable throwable) {
                var11_16 = null;
                try {
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                var11_16 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                if (out == null) return;
                out.close();
                return;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected String findContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    private String getSingleRequestString(Map request, String name) {
        Object obj = request.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            if (values.length < 1) {
                return null;
            }
            return values[0];
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }
}

