/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.vtp.framework.api.Accessibility;
import org.eclipse.vtp.framework.api.Conversation;
import org.eclipse.vtp.framework.api.ExecutionResult;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.api.InvalidResponseStrategy;
import org.eclipse.vtp.framework.api.Menu;
import org.eclipse.vtp.framework.api.MenuChoice;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.api.RetryLimitStrategy;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MenuModule
implements Module {
    private String id;
    List choices;
    boolean bargeIn = false;
    boolean retriesSeparate = false;
    int noInputLimit = 2;
    int noMatchLimit = 2;
    int badInputLimit = 2;
    Map hooks = new HashMap();
    Map endPoints = new HashMap();
    Map brandOrders = new HashMap();
    private Properties configuration = new Properties();

    public MenuModule(String id) {
        this.id = id;
        this.choices = new ArrayList();
    }

    public void addSetting(String name, Object value) {
    }

    public List getPreconditions() {
        return new ArrayList();
    }

    public void readSettings(Element element) {
        MenuModuleChoice mc;
        this.bargeIn = Boolean.valueOf(element.getAttribute("barge-in"));
        if (!element.getAttribute("retry-strategy").equals("")) {
            this.retriesSeparate = element.getAttribute("retry-strategy").equals("separate");
        }
        if (!element.getAttribute("no-input-limit").equals("")) {
            try {
                this.noInputLimit = Integer.parseInt(element.getAttribute("no-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("no-match-limit").equals("")) {
            try {
                this.noMatchLimit = Integer.parseInt(element.getAttribute("no-match-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("bad-input-limit").equals("")) {
            try {
                this.badInputLimit = Integer.parseInt(element.getAttribute("bad-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {
                this.badInputLimit = 2;
            }
        }
        NodeList nl = element.getElementsByTagName("choice");
        int i = 0;
        while (i < nl.getLength()) {
            Element ch = (Element)nl.item(i);
            this.choices.add(new MenuModuleChoice(ch.getAttribute("name"), "-1", false));
            ++i;
        }
        NodeList brandOrdersList = element.getElementsByTagName("brand-order");
        if (brandOrdersList.getLength() == 0) {
            ArrayList<MenuModuleChoice> defaultList = new ArrayList<MenuModuleChoice>();
            int i2 = 0;
            while (i2 < this.choices.size()) {
                mc = (MenuModuleChoice)this.choices.get(i2);
                defaultList.add(mc);
                ++i2;
            }
            this.brandOrders.put("Default", defaultList);
        }
        int i3 = 0;
        while (i3 < brandOrdersList.getLength()) {
            ArrayList<MenuModuleChoice> brandList = new ArrayList<MenuModuleChoice>();
            Element brandOrderElement = (Element)brandOrdersList.item(i3);
            String brandName = brandOrderElement.getAttribute("brand");
            System.out.println("Brand: " + brandName);
            NodeList entryList = brandOrderElement.getElementsByTagName("entry");
            int e = 0;
            while (e < entryList.getLength()) {
                Element entryElement = (Element)entryList.item(e);
                System.out.print("\tEntry: " + entryElement.getAttribute("name") + " - ");
                int x = 0;
                while (x < this.choices.size()) {
                    MenuModuleChoice mc2 = (MenuModuleChoice)this.choices.get(x);
                    if (mc2.name.equals(entryElement.getAttribute("name"))) {
                        System.out.print(mc2);
                        brandList.add(mc2);
                        break;
                    }
                    ++x;
                }
                System.out.println();
                ++e;
            }
            this.brandOrders.put(brandName, brandList);
            ++i3;
        }
        if (this.brandOrders.get("Default") == null) {
            ArrayList<MenuModuleChoice> defaultList = new ArrayList<MenuModuleChoice>();
            int i4 = 0;
            while (i4 < this.choices.size()) {
                mc = (MenuModuleChoice)this.choices.get(i4);
                defaultList.add(mc);
                ++i4;
            }
            this.brandOrders.put("Default", defaultList);
        }
    }

    public Interaction getInstance() {
        return new MenuInteraction();
    }

    public ModuleDestination getHookDestination(String hookName) {
        return (ModuleDestination)this.hooks.get(hookName);
    }

    public void registerHookDestination(String hookName, ModuleDestination destination) {
        this.hooks.put(hookName, destination);
    }

    public void registerEndPointDestination(String endPointName, Destination destination) {
        this.endPoints.put(endPointName, destination);
    }

    public Destination getEndPointDestination(String endPointName) {
        return (Destination)this.endPoints.get(endPointName);
    }

    public void setTimeoutDestination(Destination timeoutDestination) {
    }

    public Destination getTimeoutDestination() {
        return null;
    }

    public Map getSettings() {
        return new HashMap();
    }

    public String getName() {
        return "Menu";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return "buildin.menu.1_0_0_0";
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String name, String value) {
        this.configuration.setProperty(name, value);
    }

    public class MenuInteraction
    implements Interaction {
        public ExecutionResult execute(Conversation conversation) {
            System.out.println("Executing Menu");
            Menu menu = conversation.createMenu("Menu");
            menu.setName("BuiltInMenu");
            if (MenuModule.this.retriesSeparate) {
                menu.setInvalidResponseStrategy(new InvalidResponseStrategy(this){
                    int niFailures;
                    int nmFailures;
                    final /* synthetic */ MenuInteraction this$1;
                    {
                        this.this$1 = menuInteraction;
                        this.niFailures = 0;
                        this.nmFailures = 0;
                    }

                    public boolean noMatch() {
                        ++this.nmFailures;
                        return this.nmFailures < MenuInteraction.access$0((MenuInteraction)this.this$1).noInputLimit;
                    }

                    public boolean noInput() {
                        ++this.niFailures;
                        return this.niFailures < MenuInteraction.access$0((MenuInteraction)this.this$1).noMatchLimit;
                    }
                });
            } else {
                menu.setInvalidResponseStrategy((InvalidResponseStrategy)new RetryLimitStrategy(MenuModule.this.badInputLimit));
            }
            List choices = (List)MenuModule.this.brandOrders.get(conversation.getBrand());
            if (choices == null && (choices = (List)MenuModule.this.brandOrders.get("Default")) == null) {
                choices = MenuModule.this.choices;
            }
            System.out.println("Number of Choices: " + choices.size());
            int i = 0;
            while (i < choices.size()) {
                MenuModuleChoice mc = (MenuModuleChoice)choices.get(i);
                int num = 0;
                num = mc.dtmf.equals("*") ? 10 : (mc.dtmf.equals("#") ? 11 : Integer.parseInt(mc.dtmf));
                System.out.println("\tChoice: " + mc.name + " [" + num + "]");
                menu.addChoice(mc.name, Prompt.named((String)("option:" + mc.name)), num, !mc.silent ? Accessibility.NORMAL : Accessibility.HIDDEN);
                ++i;
            }
            if (menu.processRequest()) {
                MenuChoice sel = menu.getSelection();
                int i2 = 0;
                while (i2 < choices.size()) {
                    MenuModuleChoice mc = (MenuModuleChoice)choices.get(i2);
                    if (mc.name.equals(sel.getName())) {
                        return ExecutionResult.success((String)mc.name);
                    }
                    ++i2;
                }
            }
            if (menu.failedWithNoMatch()) {
                return ExecutionResult.failure((String)"error.input.nomatch");
            }
            return ExecutionResult.failure((String)"error.input.noinput");
        }

        static /* synthetic */ MenuModule access$0(MenuInteraction menuInteraction) {
            return menuInteraction.MenuModule.this;
        }
    }

    public class MenuModuleChoice {
        String name;
        String dtmf;
        boolean silent;

        public MenuModuleChoice(String name, String dtmf, boolean silent) {
            this.name = name;
            this.dtmf = dtmf;
            this.silent = silent;
        }
    }
}

