/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.api.DefaultInvalidResponseStrategy;
import org.eclipse.vtp.framework.api.Grammar;
import org.eclipse.vtp.framework.api.InvalidResponseStrategy;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.kernel.spi.AbstractKernelDialog;
import org.eclipse.vtp.framework.kernel.spi.KernelRequest;

public abstract class AbstractKernelRequest
extends AbstractKernelDialog
implements KernelRequest {
    private final Object timer = new Object();
    private volatile boolean complete = false;
    private volatile boolean success = false;
    private volatile boolean hadNoInput = false;
    private volatile boolean hadNoMatch = false;
    private volatile boolean processing = false;
    private volatile RuntimeException pendingException = null;
    private Prompt prompt = null;
    private Prompt noInputPrompt = null;
    private Prompt noMatchPrompt = null;
    private List grammars = new LinkedList();
    private InvalidResponseStrategy strategy = new DefaultInvalidResponseStrategy();
    private int timeout = 180;

    public boolean failedWithNoInput() {
        return this.hadNoInput;
    }

    public boolean failedWithNoMatch() {
        return this.hadNoMatch;
    }

    public final void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public final Prompt getPrompt() {
        return this.prompt;
    }

    public final void setNoInputPrompt(Prompt noInputPrompt) {
        this.noInputPrompt = noInputPrompt;
    }

    protected final Prompt getNoInputPrompt() {
        return this.noInputPrompt;
    }

    public final void setNoMatchPrompt(Prompt noMatchPrompt) {
        this.noMatchPrompt = noMatchPrompt;
    }

    protected final Prompt getNoMatchPrompt() {
        return this.noMatchPrompt;
    }

    public final void addGrammar(Grammar grammar) {
        this.grammars.add(grammar);
    }

    protected final Grammar[] getGrammars() {
        return this.grammars.toArray(new Grammar[this.grammars.size()]);
    }

    public final void setInvalidResponseStrategy(InvalidResponseStrategy strategy) {
        this.strategy = strategy;
    }

    public final boolean processRequest() {
        if (this.complete) {
            this.complete = false;
            this.success = false;
            this.hadNoInput = false;
            this.hadNoMatch = false;
            this.processing = false;
        }
        return this.getKernel().requestInformation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitToComplete(int seconds) {
        Object object = this.timer;
        synchronized (object) {
            try {
                this.timer.wait(300000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        long waited = 0L;
        long toWait = seconds * 1000;
        while (waited < toWait && !this.complete && this.processing) {
            long startedWaiting = System.currentTimeMillis();
            Object object2 = this.timer;
            synchronized (object2) {
                try {
                    this.timer.wait(toWait - waited);
                }
                catch (InterruptedException interruptedException) {}
            }
            waited += Math.max(System.currentTimeMillis() - startedWaiting, 1L);
        }
        if (!this.complete) {
            this.pendingException = new RuntimeException("Request Timeout Exceeded.");
        }
        if (this.pendingException != null) {
            throw this.pendingException;
        }
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beginProcessing() {
        Object object = this.timer;
        synchronized (object) {
            this.processing = true;
            this.timer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean noInput() {
        this.hadNoInput = true;
        this.hadNoMatch = false;
        boolean ret = this.strategy.noInput();
        if (!ret) {
            Object object = this.timer;
            synchronized (object) {
                this.complete = true;
                this.success = false;
                this.processing = false;
                this.timer.notifyAll();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean noMatch() {
        this.hadNoInput = false;
        this.hadNoMatch = true;
        boolean ret = this.strategy.noMatch();
        if (!ret) {
            Object object = this.timer;
            synchronized (object) {
                this.complete = true;
                this.processing = false;
                this.success = false;
                this.timer.notifyAll();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void throwException(RuntimeException ex) {
        Object object = this.timer;
        synchronized (object) {
            this.pendingException = ex;
            this.complete = true;
            this.processing = false;
            this.timer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void complete(Map responseData) {
        this.hadNoInput = false;
        this.hadNoMatch = false;
        this.setResponse(responseData);
        Object object = this.timer;
        synchronized (object) {
            this.complete = true;
            this.processing = false;
            this.success = true;
            this.timer.notifyAll();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public abstract boolean isValid(Map var1);

    protected abstract void setResponse(Map var1);
}

