/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.framework.api.AttachedDataRequest;
import org.eclipse.vtp.framework.kernel.spi.AbstractKernelRequest;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.Block;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.Form;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.Parameter;
import org.eclipse.vtp.framework.widgets.vxml.Submit;
import org.eclipse.vtp.framework.widgets.vxml.Variable;
import org.eclipse.vtp.framework.widgets.vxml.genesys.UserData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DefaultAttachedDataRequest
extends AbstractKernelRequest
implements AttachedDataRequest {
    private Map dataMap = new HashMap();

    protected void setResponse(Map data) {
        String[] response = (String[])data.get("attached_data");
        if (response != null && response.length > 0) {
            String userdata = response[0];
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                if (userdata != null) {
                    StringReader userdataReader = new StringReader(userdata);
                    InputSource inputSource = new InputSource(userdataReader);
                    Document doc = builder.parse(inputSource);
                    Element recordSet = doc.getDocumentElement();
                    NodeList records = recordSet.getChildNodes();
                    int i = 0;
                    while (i < records.getLength()) {
                        Node record = records.item(i);
                        if (record instanceof Element) {
                            NamedNodeMap keyAttributes = record.getAttributes();
                            String name = keyAttributes.getNamedItem("name").getNodeValue();
                            String value = keyAttributes.getNamedItem("value").getNodeValue();
                            this.dataMap.put(name, value);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addRequestedAttachedDataKey(String key) {
        this.dataMap.put(key, "");
    }

    public String getAttachedDataValue(String key) {
        return (String)this.dataMap.get(key);
    }

    public Dialog produceDialog(String callId) {
        UserData userData = new UserData("attached_data");
        userData.setDoGet(true);
        Set set = this.dataMap.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            userData.addParameter(new Parameter((String)iter.next(), "''"));
        }
        Block block = new Block("var_block");
        block.addAction((Action)new Submit(String.valueOf(this.getKernel().getContextPath()) + "/openVXML", new String[]{"KERNEL_CALL_ID", "KERNEL_EVENT", "attached_data"}));
        Form userDataForm = new Form("User_Data_Form");
        userDataForm.addVariable(new Variable("KERNEL_CALL_ID", "\"" + callId + "\""));
        userDataForm.addVariable(new Variable("KERNEL_EVENT", "\"FILLED\""));
        userDataForm.addFormElement((FormElement)userData);
        userDataForm.addFormElement((FormElement)block);
        return userDataForm;
    }

    public boolean isValid(Map data) {
        return true;
    }
}

