/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.util.Map;
import org.eclipse.vtp.framework.api.DTMF;
import org.eclipse.vtp.framework.api.FieldValidator;
import org.eclipse.vtp.framework.api.Grammar;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.kernel.api.DialogProducer;
import org.eclipse.vtp.framework.kernel.spi.AbstractKernelRequest;
import org.eclipse.vtp.framework.kernel.spi.MediaRenderer;
import org.eclipse.vtp.framework.media.util.DialogAggregate;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.Assignment;
import org.eclipse.vtp.framework.widgets.vxml.Block;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.Field;
import org.eclipse.vtp.framework.widgets.vxml.Filled;
import org.eclipse.vtp.framework.widgets.vxml.Form;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.NoInput;
import org.eclipse.vtp.framework.widgets.vxml.NoMatch;
import org.eclipse.vtp.framework.widgets.vxml.Submit;
import org.eclipse.vtp.framework.widgets.vxml.Variable;

public class DefaultField
extends AbstractKernelRequest
implements org.eclipse.vtp.framework.api.Field,
DialogProducer {
    private String value = "";
    private int interdigitTimeout = -1;
    private int terminationTimeout = -1;
    private int initialTimeout = -1;
    private FieldValidator validator = null;
    private int terminationDigit = 11;

    public DefaultField() {
        this.setPrompt(Prompt.named((String)"field"));
        this.setNoInputPrompt(Prompt.named((String)"no-input"));
        this.setNoMatchPrompt(Prompt.named((String)"no-match"));
    }

    public Dialog produceDialog(String callId) {
        MediaRenderer renderer = this.getMediaRenderer();
        Field field = new Field(this.getName());
        DialogAggregate dialog = renderer.getDialog(this.getDialogName());
        if (dialog != null) {
            switch (dialog.getInputMode()) {
                case 0: {
                    field.addProperty("com.telera.speechenabled", "false");
                    field.addProperty("inputmodes", "dtmf");
                    break;
                }
                case 1: {
                    field.addProperty("com.telera.speechenabled", "true");
                    field.addProperty("inputmodes", "voice");
                    break;
                }
                case 2: {
                    field.addProperty("com.telera.speechenabled", "true");
                    field.addProperty("inputmodes", "dtmf voice");
                }
            }
            if (Boolean.TRUE.equals(dialog.getBargeIn())) {
                field.addProperty("bargein", "true");
            } else if (Boolean.FALSE.equals(dialog.getBargeIn())) {
                field.addProperty("bargein", "false");
            } else {
                field.addProperty("bargein", "true");
            }
            if (this.initialTimeout >= 0) {
                field.addProperty("timeout", String.valueOf(this.initialTimeout) + "s");
            } else if (dialog.getInitialInputTimeout() >= 0L) {
                field.addProperty("timeout", String.valueOf(String.valueOf(dialog.getInitialInputTimeout())) + "s");
            }
            if (dialog.getInputMode() != 1) {
                if (this.interdigitTimeout >= 0) {
                    field.addProperty("interdigittimeout", String.valueOf(this.interdigitTimeout) + "s");
                } else if (dialog.getInterDigitTimeout() >= 0L) {
                    field.addProperty("interdigittimeout", String.valueOf(String.valueOf(dialog.getInterDigitTimeout())) + "s");
                }
                if (this.terminationTimeout >= 0) {
                    field.addProperty("termtimeout", String.valueOf(this.terminationTimeout) + "s");
                } else if (dialog.getTerminationTimeout() >= 0L) {
                    field.addProperty("termtimeout", String.valueOf(String.valueOf(dialog.getTerminationTimeout())) + "s");
                }
                if (dialog.getTerminationCharacter() > '\u0000') {
                    field.addProperty("termchar", String.valueOf(dialog.getTerminationCharacter()));
                } else if (dialog.getTerminationCharacter() == '\u0000') {
                    field.addProperty("termchar", String.valueOf('D'));
                } else {
                    field.addProperty("termchar", DTMF.KEY_NAMES[this.terminationDigit]);
                }
            }
            if (dialog.getInputMode() != 0) {
                if (dialog.getConfidenceLevel() != null) {
                    field.addProperty("confidencelevel", String.valueOf(dialog.getConfidenceLevel()));
                }
                if (dialog.getSensitivity() != null) {
                    field.addProperty("sensitivity", String.valueOf(dialog.getSensitivity()));
                }
                if (dialog.getSpeedVsAccuracy() != null) {
                    field.addProperty("speedvsaccuracy", String.valueOf(dialog.getSpeedVsAccuracy()));
                }
                if (dialog.getSpeechCompletionTimeout() >= 0L) {
                    field.addProperty("completetimeout", String.valueOf(String.valueOf(dialog.getSpeechCompletionTimeout())) + "s");
                }
                if (dialog.getIncompleteSpeechTimeout() >= 0L) {
                    field.addProperty("incompletetimeout", String.valueOf(String.valueOf(dialog.getIncompleteSpeechTimeout())) + "s");
                }
                if (dialog.getMaximumSpeechLength() >= 0) {
                    field.addProperty("maxspeechtimeout", String.valueOf(String.valueOf(dialog.getMaximumSpeechLength())) + "s");
                }
                if (dialog.getMaximumNBestResults() >= 0) {
                    field.addProperty("maxnbest", String.valueOf(dialog.getMaximumNBestResults()));
                }
            }
        } else {
            field.addProperty("com.telera.speechenabled", "false");
            field.addProperty("inputmodes", "dtmf");
            if (this.initialTimeout >= 0) {
                field.addProperty("timeout", String.valueOf(this.initialTimeout) + "s");
            }
            if (this.interdigitTimeout >= 0) {
                field.addProperty("interdigittimeout", String.valueOf(this.interdigitTimeout) + "s");
            }
            if (this.terminationTimeout >= 0) {
                field.addProperty("termtimeout", String.valueOf(this.terminationTimeout) + "s");
            }
            field.addProperty("termchar", "");
        }
        field.setPrompt(renderer.renderPrompt(this.getPrompt() == null ? Prompt.named((String)"field") : this.getPrompt(), dialog == null ? true : (dialog.getBargeIn() == null ? true : dialog.getBargeIn())));
        Filled filled = new Filled();
        filled.addAction((Action)new Submit(String.valueOf(this.getKernel().getContextPath()) + "/openVXML", new String[]{this.getName(), "KERNEL_CALL_ID", "KERNEL_EVENT"}));
        field.addFilledHandler(filled);
        NoInput noInput = new NoInput();
        noInput.addAction((Action)new Assignment("KERNEL_EVENT", "\"NOINPUT\""));
        noInput.addAction((Action)new Submit(String.valueOf(this.getKernel().getContextPath()) + "/openVXML", new String[]{this.getName(), "KERNEL_CALL_ID", "KERNEL_EVENT"}));
        field.addEventHandler((EventHandler)noInput);
        NoMatch noMatch = new NoMatch();
        noMatch.addAction((Action)new Assignment("KERNEL_EVENT", "\"NOMATCH\""));
        noMatch.addAction((Action)new Submit(String.valueOf(this.getKernel().getContextPath()) + "/openVXML", new String[]{this.getName(), "KERNEL_CALL_ID", "KERNEL_EVENT"}));
        field.addEventHandler((EventHandler)noMatch);
        Grammar[] grammars = this.getGrammars();
        field.setGrammar(renderer.renderGrammar(grammars.length == 0 ? Grammar.named((String)"field") : grammars[0]));
        Form form = new Form("Default_Field_Form");
        form.addVariable(new Variable("KERNEL_CALL_ID", "'" + callId + "'"));
        form.addVariable(new Variable("KERNEL_EVENT", "'FILLED'"));
        if (this.failedWithNoInput()) {
            Block block = new Block("Default_Field_No_Input_Block");
            block.addAction((Action)renderer.renderPrompt(this.getNoInputPrompt() == null ? Prompt.named((String)"no-input") : this.getNoInputPrompt()));
            form.addFormElement((FormElement)block);
        } else if (this.failedWithNoMatch()) {
            Block block = new Block("Default_Field_No_Match_Block");
            block.addAction((Action)renderer.renderPrompt(this.getNoMatchPrompt() == null ? Prompt.named((String)"no-match") : this.getNoMatchPrompt()));
            form.addFormElement((FormElement)block);
        }
        form.addFormElement((FormElement)field);
        return form;
    }

    public void setInterdigitTimeout(int timeout) {
        this.interdigitTimeout = timeout;
    }

    public void setTerminationTimeout(int timeout) {
        this.terminationTimeout = timeout;
    }

    public void setInitialTimeout(int timeout) {
        this.initialTimeout = timeout;
    }

    protected void setResponse(Map data) {
        String[] results = (String[])data.get(this.getName());
        this.value = results != null && results.length > 0 ? results[0] : "";
    }

    public String getValue() {
        return this.value;
    }

    public void setValidator(FieldValidator validator) {
        this.validator = validator;
    }

    public void setTerminationDigit(int digit) {
        this.terminationDigit = digit;
    }

    public void canBargeIn(boolean bargeIn) {
    }

    public boolean isValid(Map data) {
        String newValue = "";
        String[] results = (String[])data.get(this.getName());
        newValue = results != null && results.length > 0 ? results[0] : "";
        return this.validator == null || this.validator.isValid(newValue);
    }
}

