/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.api.Accessibility;
import org.eclipse.vtp.framework.api.DTMF;
import org.eclipse.vtp.framework.api.Grammar;
import org.eclipse.vtp.framework.api.MenuChoice;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.kernel.api.DialogProducer;
import org.eclipse.vtp.framework.kernel.spi.AbstractKernelRequest;
import org.eclipse.vtp.framework.kernel.spi.MediaRenderer;
import org.eclipse.vtp.framework.media.util.DialogAggregate;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.Choice;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.Goto;
import org.eclipse.vtp.framework.widgets.vxml.Menu;
import org.eclipse.vtp.framework.widgets.vxml.NoInput;
import org.eclipse.vtp.framework.widgets.vxml.NoMatch;

public class DefaultMenu
extends AbstractKernelRequest
implements org.eclipse.vtp.framework.api.Menu,
DialogProducer {
    private int selection = -1;
    private List choices = new LinkedList();
    private int interdigitTimeout = -1;
    private int terminationTimeout = -1;
    private int initialTimeout = -2;

    public DefaultMenu() {
        this.setPrompt(Prompt.named((String)"menu"));
        this.setNoInputPrompt(Prompt.named((String)"no-input"));
        this.setNoMatchPrompt(Prompt.named((String)"no-match"));
    }

    public void setInterdigitTimeout(int timeout) {
        this.interdigitTimeout = timeout;
    }

    public void setTerminationTimeout(int timeout) {
        this.terminationTimeout = timeout;
    }

    public void setInitialTimeout(int timeout) {
        this.initialTimeout = timeout;
    }

    public void addChoice(String choiceName, Prompt prompt, int number) {
        this.addChoice(choiceName, prompt, number, Accessibility.NORMAL);
    }

    public void addChoice(String choiceName, Prompt prompt, int number, Accessibility access) {
        if (number < -1 && number > 11) {
            throw new IllegalArgumentException("Number must be 0 through 11");
        }
        this.choices.add(new MenuChoiceImpl(choiceName, prompt, number, access));
    }

    public Dialog produceDialog(String callId) {
        MediaRenderer renderer = this.getMediaRenderer();
        Prompt prompt = null;
        if (this.failedWithNoInput()) {
            prompt = this.getNoInputPrompt() == null ? Prompt.named((String)"no-input") : this.getNoInputPrompt();
            prompt = prompt.followedBy(this.getPrompt() == null ? Prompt.named((String)"menu") : this.getPrompt());
        } else if (this.failedWithNoMatch()) {
            prompt = this.getNoMatchPrompt() == null ? Prompt.named((String)"no-match") : this.getNoMatchPrompt();
            prompt = prompt.followedBy(this.getPrompt() == null ? Prompt.named((String)"menu") : this.getPrompt());
        } else {
            prompt = this.getPrompt() == null ? Prompt.named((String)"menu") : this.getPrompt();
        }
        int i = 0;
        while (i < this.choices.size()) {
            Grammar choiceGrammar;
            Accessibility choiceAccess = ((MenuChoice)this.choices.get(i)).getAccessibility();
            Prompt choicePrompt = ((MenuChoice)this.choices.get(i)).getPrompt();
            if (choicePrompt == null) {
                choicePrompt = Prompt.named((String)("option:" + ((MenuChoice)this.choices.get(i)).getName()));
            }
            if (Accessibility.NORMAL.equals((Object)choiceAccess)) {
                Prompt prompt2 = prompt = prompt == null ? choicePrompt : prompt.followedBy(choicePrompt);
            }
            if ((choiceGrammar = ((MenuChoice)this.choices.get(i)).getGrammar()) == null) {
                ((MenuChoice)this.choices.get(i)).setGrammar(Grammar.named((String)("option:" + ((MenuChoice)this.choices.get(i)).getName())));
            }
            ++i;
        }
        DialogAggregate dialog = renderer.getDialog(this.getDialogName());
        Menu menu = new Menu(this.getName(), renderer.renderPrompt(prompt, dialog == null ? true : (dialog.getBargeIn() == null ? true : dialog.getBargeIn())));
        if (dialog != null) {
            switch (dialog.getInputMode()) {
                case 0: {
                    menu.addProperty("com.telera.speechenabled", "false");
                    menu.addProperty("inputmodes", "dtmf");
                    break;
                }
                case 1: {
                    menu.addProperty("com.telera.speechenabled", "true");
                    menu.addProperty("inputmodes", "voice");
                    break;
                }
                case 2: {
                    menu.addProperty("com.telera.speechenabled", "true");
                    menu.addProperty("inputmodes", "dtmf voice");
                }
            }
            if (Boolean.TRUE.equals(dialog.getBargeIn())) {
                menu.setProperty("bargein", "true");
            } else if (Boolean.FALSE.equals(dialog.getBargeIn())) {
                menu.setProperty("bargein", "false");
            } else {
                menu.setProperty("bargein", "true");
            }
            if (this.initialTimeout >= 0) {
                menu.addProperty("timeout", String.valueOf(this.initialTimeout) + "s");
            } else if (dialog.getInitialInputTimeout() >= 0L) {
                menu.addProperty("timeout", String.valueOf(String.valueOf(dialog.getInitialInputTimeout())) + "s");
            }
            if (dialog.getInputMode() != 1) {
                if (this.interdigitTimeout >= 0) {
                    menu.addProperty("interdigittimeout", String.valueOf(this.interdigitTimeout) + "s");
                } else if (dialog.getInterDigitTimeout() >= 0L) {
                    menu.setProperty("interdigittimeout", String.valueOf(String.valueOf(dialog.getInterDigitTimeout())) + "s");
                }
                if (this.terminationTimeout >= 0) {
                    menu.addProperty("termtimeout", String.valueOf(this.terminationTimeout) + "s");
                } else if (dialog.getTerminationTimeout() >= 0L) {
                    menu.setProperty("termtimeout", String.valueOf(String.valueOf(dialog.getTerminationTimeout())) + "s");
                }
                if (dialog.getTerminationCharacter() > '\u0000') {
                    menu.setProperty("termchar", String.valueOf(dialog.getTerminationCharacter()));
                } else {
                    menu.addProperty("termchar", "");
                }
            }
            if (dialog.getInputMode() != 0) {
                if (dialog.getConfidenceLevel() != null) {
                    menu.setProperty("confidencelevel", String.valueOf(dialog.getConfidenceLevel()));
                }
                if (dialog.getSensitivity() != null) {
                    menu.setProperty("sensitivity", String.valueOf(dialog.getSensitivity()));
                }
                if (dialog.getSpeedVsAccuracy() != null) {
                    menu.setProperty("speedvsaccuracy", String.valueOf(dialog.getSpeedVsAccuracy()));
                }
                if (dialog.getSpeechCompletionTimeout() >= 0L) {
                    menu.setProperty("completetimeout", String.valueOf(String.valueOf(dialog.getSpeechCompletionTimeout())) + "s");
                }
                if (dialog.getIncompleteSpeechTimeout() >= 0L) {
                    menu.setProperty("incompletetimeout", String.valueOf(String.valueOf(dialog.getIncompleteSpeechTimeout())) + "s");
                }
                if (dialog.getMaximumSpeechLength() >= 0) {
                    menu.setProperty("maxspeechtimeout", String.valueOf(String.valueOf(dialog.getMaximumSpeechLength())) + "s");
                }
                if (dialog.getMaximumNBestResults() >= 0) {
                    menu.setProperty("maxnbest", String.valueOf(dialog.getMaximumNBestResults()));
                }
            }
        } else {
            menu.addProperty("com.telera.speechenabled", "false");
            menu.addProperty("inputmodes", "dtmf");
            if (this.initialTimeout >= 0) {
                menu.addProperty("timeout", String.valueOf(this.initialTimeout) + "s");
            }
            if (this.interdigitTimeout >= 0) {
                menu.addProperty("interdigittimeout", String.valueOf(this.interdigitTimeout) + "s");
            }
            if (this.terminationTimeout >= 0) {
                menu.addProperty("termtimeout", String.valueOf(this.terminationTimeout) + "s");
            }
            menu.addProperty("termchar", "");
        }
        int i2 = 0;
        while (i2 < this.choices.size()) {
            MenuChoice mc = (MenuChoice)this.choices.get(i2);
            System.out.println("Choice: " + mc.getName() + ", DTMF=" + mc.getDTMF());
            String choiceNumber = Integer.toString(i2 + 1);
            if (mc.getDTMF() == -1) {
                if (dialog != null) {
                    System.out.println(dialog);
                    System.out.println(dialog.getMenuOptionDtmfSetting(mc.getName()));
                    choiceNumber = dialog.getMenuOptionDtmfSetting(mc.getName()).toString();
                }
            } else {
                choiceNumber = DTMF.KEY_NAMES[mc.getDTMF()];
            }
            Accessibility choiceAccess = mc.getAccessibility();
            Choice choice = null;
            if (!Accessibility.ABSENT.equals((Object)choiceAccess)) {
                choice = new Choice(String.valueOf(this.getKernel().getContextPath()) + "/openVXML" + "?" + "KERNEL_CALL_ID" + "=" + callId + "&KERNEL_EVENT=FILLED&" + this.getName() + "=" + i2, choiceNumber);
                if (dialog != null) {
                    if (dialog.getInputMode() != 0) {
                        Grammar grammar = mc.getGrammar();
                        System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@Using voice: " + grammar);
                        if (grammar != null) {
                            System.err.println("########################" + this.getMediaRenderer().renderGrammar(grammar));
                            choice.setGrammarURI(this.getMediaRenderer().renderGrammar(grammar));
                        }
                    }
                    if (dialog.getInputMode() == 1) {
                        choice.setDTMF(null);
                    }
                }
            }
            if (choice != null) {
                menu.addChoice(choice);
            }
            ++i2;
        }
        NoInput noInput = new NoInput(1);
        noInput.addAction((Action)new Goto(String.valueOf(this.getKernel().getContextPath()) + "/openVXML" + "?" + "KERNEL_CALL_ID" + "=" + callId + "&" + "KERNEL_EVENT" + "=NOINPUT"));
        menu.addEventHandler((EventHandler)noInput);
        NoMatch noMatch = new NoMatch(1);
        noMatch.addAction((Action)new Goto(String.valueOf(this.getKernel().getContextPath()) + "/openVXML" + "?" + "KERNEL_CALL_ID" + "=" + callId + "&" + "KERNEL_EVENT" + "=NOMATCH"));
        menu.addEventHandler((EventHandler)noMatch);
        return menu;
    }

    protected void setResponse(Map data) {
        String[] results = (String[])data.get(this.getName());
        this.selection = results != null && results.length > 0 ? Integer.parseInt(results[0]) : -1;
    }

    public MenuChoice getSelection() {
        return (MenuChoice)this.choices.get(this.selection);
    }

    public boolean isValid(Map data) {
        return true;
    }

    public void canBargeIn(boolean bargeIn) {
    }

    public MenuChoice getChoice(String choiceName) {
        MenuChoice ret = null;
        int i = 0;
        while (i < this.choices.size()) {
            MenuChoice mc = (MenuChoice)this.choices.get(i);
            if (mc.getName().equals(choiceName)) {
                ret = mc;
                break;
            }
            ++i;
        }
        return ret;
    }

    public List getChoices() {
        return Collections.unmodifiableList(this.choices);
    }

    public class MenuChoiceImpl
    implements MenuChoice {
        String choiceName;
        Prompt choicePrompt;
        Grammar choiceGrammar;
        Accessibility accessibility;
        int dtmf;

        public MenuChoiceImpl(String name, Prompt prompt, int dtmf, Accessibility accessibility) {
            this.choiceName = name;
            this.choicePrompt = prompt;
            this.dtmf = dtmf;
            this.accessibility = accessibility;
        }

        public String getName() {
            return this.choiceName;
        }

        public Prompt getPrompt() {
            return this.choicePrompt;
        }

        public void setPrompt(Prompt prompt) {
            this.choicePrompt = prompt;
        }

        public Grammar getGrammar() {
            return this.choiceGrammar;
        }

        public void setGrammar(Grammar grammar) {
            this.choiceGrammar = grammar;
        }

        public Accessibility getAccessibility() {
            return this.accessibility;
        }

        public void setAccessibility(Accessibility accessibility) {
            this.accessibility = accessibility;
        }

        public int getDTMF() {
            return this.dtmf;
        }
    }
}

