/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.DatePrompt;
import org.eclipse.vtp.framework.media.prompts.DateTimePrompt;
import org.eclipse.vtp.framework.media.prompts.DigitsPrompt;
import org.eclipse.vtp.framework.media.prompts.MoneyPrompt;
import org.eclipse.vtp.framework.media.prompts.NumberPrompt;
import org.eclipse.vtp.framework.media.prompts.OrdinalPrompt;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TimePrompt;
import org.eclipse.vtp.framework.media.util.BindingIndex;
import org.eclipse.vtp.framework.media.util.CustomBindingIndex;
import org.eclipse.vtp.framework.media.util.DefaultBindingIndex;
import org.eclipse.vtp.framework.media.util.PromptSolutionOutput;

public class PromptSolver {
    private DefaultBindingIndex defIndex;
    private Map custIndexes;

    public PromptSolver(DefaultBindingIndex defIndex, Map custIndexes) {
        this.defIndex = defIndex;
        this.custIndexes = new HashMap(custIndexes);
    }

    public boolean namedPromptExists(String name) {
        return true;
    }

    public boolean audioFileExists(String name) {
        if (this.defIndex.hasAudioFile(name)) {
            return true;
        }
        Iterator i = this.custIndexes.values().iterator();
        while (i.hasNext()) {
            if (!((CustomBindingIndex)i.next()).hasAudioFile(name)) continue;
            return true;
        }
        return false;
    }

    public BindingIndex getIndex(String brand) {
        if ("".equals(brand) || "Default".equals(brand)) {
            return this.defIndex;
        }
        return (CustomBindingIndex)this.custIndexes.get(brand);
    }

    public void solve(final Locale curlang, final String brand, final String module, final String instance, final String dialog, Prompt prompt, final PromptSolutionOutput output) {
        prompt.accept(new Prompt.Visitor(){

            public Object compositePrompt(Prompt first, Prompt second) {
                first.accept((Prompt.Visitor)this);
                second.accept((Prompt.Visitor)this);
                return null;
            }

            public Object externalFilePrompt(String url, String alternateText) {
                output.writeExternalFile(url, alternateText);
                return null;
            }

            public Object variablePrompt(String variableName, String language, int type) {
                switch (type) {
                    case 0: {
                        output.writeVariable(variableName, 0);
                        break;
                    }
                    case 1: {
                        output.writeVariable(variableName, 1);
                        break;
                    }
                    case 2: {
                        output.writeVariable(variableName, 2);
                        break;
                    }
                    case 3: {
                        output.writeVariable(variableName, 3);
                        break;
                    }
                    case 4: {
                        output.writeVariable(variableName, 4);
                    }
                }
                return null;
            }

            public Object textPrompt(String text, String language) {
                output.writeText(text);
                return null;
            }

            public Object numberPrompt(int number, String language) {
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new NumberPrompt(number), module, instance, output, this.getLocale(language));
                return null;
            }

            public Object ordinalPrompt(int number, String language) {
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new OrdinalPrompt(number), module, instance, output, this.getLocale(language));
                return null;
            }

            public Object namedPrompt(String name, String language) {
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new ReferencePrompt(name), module, instance, dialog, output, this.getLocale(language));
                return null;
            }

            public Object moneyPrompt(BigDecimal money, String language) {
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new MoneyPrompt(money), module, instance, output, this.getLocale(language));
                return null;
            }

            public Object digitsPrompt(String digits, String language) {
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new DigitsPrompt(digits), module, instance, output, this.getLocale(language));
                return null;
            }

            public Object datePrompt(Date date, String language) {
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new DatePrompt(date), module, instance, output, this.getLocale(language));
                return null;
            }

            public Object timePrompt(Date date, String language) {
                System.out.println("Time Prompt: " + date);
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new TimePrompt(date), module, instance, output, this.getLocale(language));
                return null;
            }

            public Object dateTimePrompt(Date date, String language) {
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new DateTimePrompt(date), module, instance, output, this.getLocale(language));
                return null;
            }

            public Object characterPrompt(String text, String language) {
                PromptSolver.this.getIndex(brand).solvePrompt((org.eclipse.vtp.framework.media.prompts.Prompt)new CharactersPrompt(text), module, instance, output, this.getLocale(language));
                return null;
            }

            public Object audioFilePrompt(String filename) {
                output.writeFile(filename);
                return null;
            }

            private Locale getLocale(String language) {
                if (language == null || language.length() == 0) {
                    if (curlang == null) {
                        return PromptSolver.this.getIndex(brand).getDefaultLocale();
                    }
                    return curlang;
                }
                String[] parts = language.split("-");
                switch (parts.length) {
                    case 1: {
                        return new Locale(parts[0]);
                    }
                    case 2: {
                        return new Locale(parts[0], parts[1]);
                    }
                }
                return new Locale(parts[0], parts[1], parts[2]);
            }
        });
    }
}

