/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.Conversation;
import org.eclipse.vtp.framework.api.ExecutionFailure;
import org.eclipse.vtp.framework.api.ExecutionResult;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.api.InvalidResponseStrategy;
import org.eclipse.vtp.framework.api.Recording;
import org.eclipse.vtp.framework.api.RetryLimitStrategy;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.w3c.dom.Element;

public class RecordingModule
implements Module {
    private String id;
    private String varName;
    boolean retriesSeparate = false;
    int noInputLimit = 2;
    int noMatchLimit = 2;
    int badInputLimit = 2;
    Map hooks = new HashMap();
    Map endPoints = new HashMap();
    private Properties configuration = new Properties();

    public RecordingModule(String id) {
        this.id = id;
    }

    public void addSetting(String name, Object value) {
    }

    public List getPreconditions() {
        return new ArrayList();
    }

    public void readSettings(Element element) {
        this.varName = element.getAttribute("var-name");
        if (!element.getAttribute("retry-strategy").equals("")) {
            this.retriesSeparate = element.getAttribute("retry-strategy").equals("separate");
        }
        if (!element.getAttribute("no-input-limit").equals("")) {
            try {
                this.noInputLimit = Integer.parseInt(element.getAttribute("no-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("no-match-limit").equals("")) {
            try {
                this.noMatchLimit = Integer.parseInt(element.getAttribute("no-match-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("bad-input-limit").equals("")) {
            try {
                this.badInputLimit = Integer.parseInt(element.getAttribute("bad-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Interaction getInstance() {
        return new FieldInteraction();
    }

    public ModuleDestination getHookDestination(String hookName) {
        return (ModuleDestination)this.hooks.get(hookName);
    }

    public void registerHookDestination(String hookName, ModuleDestination destination) {
        this.hooks.put(hookName, destination);
    }

    public void registerEndPointDestination(String endPointName, Destination destination) {
        this.endPoints.put(endPointName, destination);
    }

    public Destination getEndPointDestination(String endPointName) {
        return (Destination)this.endPoints.get(endPointName);
    }

    public void setTimeoutDestination(Destination timeoutDestination) {
    }

    public Destination getTimeoutDestination() {
        return null;
    }

    public Map getSettings() {
        return new HashMap();
    }

    public String getName() {
        return "Recording";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return "builtin.recording.1_0_0_0";
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String name, String value) {
        this.configuration.setProperty(name, value);
    }

    public class FieldInteraction
    implements Interaction {
        public ExecutionResult execute(Conversation conversation) {
            BObject var;
            ExecutionResult next = ExecutionResult.success((String)"Next");
            ExecutionFailure noMatchFailure = ExecutionResult.failure((String)"error.input.nomatch");
            ExecutionFailure noInputFailure = ExecutionResult.failure((String)"error.input.noinput");
            Recording recording = conversation.createRecording("Recording");
            recording.setName("BuiltInRecording");
            if (RecordingModule.this.retriesSeparate) {
                recording.setInvalidResponseStrategy(new InvalidResponseStrategy(this){
                    int niFailures;
                    int nmFailures;
                    final /* synthetic */ FieldInteraction this$1;
                    {
                        this.this$1 = fieldInteraction;
                        this.niFailures = 0;
                        this.nmFailures = 0;
                    }

                    public boolean noMatch() {
                        ++this.nmFailures;
                        return this.nmFailures < FieldInteraction.access$0((FieldInteraction)this.this$1).noInputLimit;
                    }

                    public boolean noInput() {
                        ++this.niFailures;
                        return this.niFailures < FieldInteraction.access$0((FieldInteraction)this.this$1).noMatchLimit;
                    }
                });
            } else {
                recording.setInvalidResponseStrategy((InvalidResponseStrategy)new RetryLimitStrategy(RecordingModule.this.badInputLimit));
            }
            if (recording.processRequest()) {
                var = conversation.getVariable(RecordingModule.this.varName);
                if (var == null) {
                    var = conversation.createObject(RecordingModule.this.varName, "Recording", false);
                    conversation.registerVariable(RecordingModule.this.varName, var);
                }
            } else {
                if (recording.failedWithNoMatch()) {
                    return noMatchFailure;
                }
                return noInputFailure;
            }
            BObject urlField = var.getField("url");
            urlField.setValue((Object)recording.getRecording());
            return next;
        }

        static /* synthetic */ RecordingModule access$0(FieldInteraction fieldInteraction) {
            return fieldInteraction.RecordingModule.this;
        }
    }
}

