/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.shared.actions.util;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningActionItem;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningActionItemFilter;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningModelSelection;
import org.osgi.framework.Bundle;

public abstract class InternalActionItem
implements IProvisioningActionItem {
    private String containerId;
    private String name;
    private String toolTip = "";
    private int state = 2;
    private boolean canProcess = true;
    private String targetClassString = null;
    private String filterClassString = null;
    private Class targetClass = null;
    private Class filterClass = null;
    private IProvisioningActionItemFilter filter = null;
    private IProvisioningModelSelection currentSelection = null;
    protected String pluginNameSpace;

    public InternalActionItem(String containerId, String name) {
        this.name = name;
        this.containerId = containerId;
    }

    public void setPluginNameSpace(String pluginNameSpace) {
        this.pluginNameSpace = pluginNameSpace;
    }

    public String getName() {
        return this.name;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setName(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Action Item name cannot be null or the empty string.");
        }
        this.name = name;
    }

    public void setToolTip(String toolTip) {
        if (toolTip == null) {
            toolTip = "";
        }
        this.toolTip = toolTip;
    }

    public void setTargetClass(String classString) {
        this.targetClassString = classString;
    }

    public void setFilterClass(String filterClassString) {
        this.filterClassString = filterClassString;
    }

    public IProvisioningModelSelection getCurrentSelection() {
        return this.currentSelection;
    }

    public void processSelectionChange(IProvisioningModelSelection selection) {
        this.currentSelection = selection;
        if (this.canProcess) {
            if (this.targetClassString != null) {
                if (this.targetClass == null) {
                    try {
                        Bundle bundle = Platform.getBundle((String)this.pluginNameSpace);
                        this.targetClass = bundle.loadClass(this.targetClassString);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        this.state = 1;
                        this.canProcess = false;
                        return;
                    }
                }
                this.state = selection.getSelectedObject() != null && this.targetClass.isAssignableFrom(selection.getSelectedObject().getClass()) ? 2 : 1;
            } else if (this.filterClassString != null) {
                if (this.filter == null) {
                    try {
                        Bundle bundle = Platform.getBundle((String)this.pluginNameSpace);
                        this.filterClass = bundle.loadClass(this.filterClassString);
                        Constructor constructor = this.filterClass.getConstructor(new Class[0]);
                        this.filter = (IProvisioningActionItemFilter)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.state = 1;
                        this.canProcess = false;
                        return;
                    }
                }
                this.state = this.filter.appliesTo(selection);
            } else {
                this.canProcess = false;
            }
        }
    }

    public int getAvailability() {
        return this.state;
    }
}

