/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.shared.actions.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningActionItemSorter;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningActionSet;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningModelSelection;
import org.eclipse.vtp.desktop.ui.shared.actions.util.InternalActionItem;
import org.eclipse.vtp.desktop.ui.shared.actions.util.InternalActionItemContainer;
import org.eclipse.vtp.desktop.ui.shared.actions.util.InternalActionSetSection;
import org.eclipse.vtp.desktop.ui.shared.actions.util.SectionConstraint;

public class InternalActionSet
extends InternalActionItem
implements IProvisioningActionSet,
InternalActionItemContainer {
    private List sectionList = new ArrayList();
    private Map sectionMap = new HashMap();
    private InternalActionSetSection head;
    private InternalActionSetSection content;
    private InternalActionSetSection tail;

    public InternalActionSet(String containerId, String name) {
        super(containerId, name);
        this.head = new InternalActionSetSection(String.valueOf(containerId) + "." + name, "HEAD", new SectionConstraint(0, null));
        this.content = new InternalActionSetSection(String.valueOf(containerId) + "." + name, "CONTENT", new SectionConstraint(0, null));
        this.tail = new InternalActionSetSection(String.valueOf(containerId) + "." + name, "TAIL", new SectionConstraint(0, null));
        this.sectionList.add(this.head);
        this.sectionMap.put("HEAD", this.head);
        this.sectionList.add(this.content);
        this.sectionMap.put("CONTENT", this.content);
        this.sectionList.add(this.tail);
        this.sectionMap.put("TAIL", this.tail);
    }

    public void setSorter(IProvisioningActionItemSorter sorter) {
        this.head.setSorter(sorter);
        this.content.setSorter(sorter);
        this.tail.setSorter(sorter);
    }

    public boolean addActionItem(InternalActionItem actionItem) {
        return this.content.addActionItem(actionItem);
    }

    public boolean addSection(InternalActionSetSection section) {
        SectionConstraint location = section.getLocation();
        if (this.sectionMap.get(section.getName()) != null) {
            return false;
        }
        if (location.getConstraint() == 0) {
            this.sectionList.add(section);
            this.sectionMap.put(section.getName(), section);
            return true;
        }
        int i = 0;
        while (i < this.sectionList.size()) {
            InternalActionSetSection currentSection = (InternalActionSetSection)this.sectionList.get(i);
            if (currentSection.equals(location.getLocation())) {
                if (location.getConstraint() == 1) {
                    this.sectionList.add(i, section);
                    this.sectionMap.put(section.getName(), section);
                    return true;
                }
                if (location.getConstraint() == 2) {
                    this.sectionList.add(i + 1, section);
                    this.sectionMap.put(section.getName(), section);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public InternalActionItemContainer findContainer(Stack ids) {
        if (ids.size() == 0) {
            return this.content;
        }
        String currentId = (String)ids.peek();
        Object obj = this.sectionMap.get(currentId);
        if (obj == null) {
            return this.content.findContainer(ids);
        }
        ids.pop();
        if (ids.size() > 0) {
            return ((InternalActionSetSection)obj).findContainer(ids);
        }
        return (InternalActionItemContainer)obj;
    }

    public void processSelectionChange(IProvisioningModelSelection selection) {
        super.processSelectionChange(selection);
        if (this.getAvailability() == 2) {
            int i = 0;
            while (i < this.sectionList.size()) {
                ((InternalActionSetSection)this.sectionList.get(i)).processSelectionChange(selection);
                ++i;
            }
        }
    }

    public void fillContextMenu(IMenuManager menuManager) {
        int i = 0;
        while (i < this.sectionList.size()) {
            ((InternalActionSetSection)this.sectionList.get(i)).fillContextMenu(menuManager);
            ++i;
        }
    }
}

