/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.shared.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.vtp.desktop.ui.shared.custom.LinkRenderer;
import org.eclipse.vtp.desktop.ui.shared.custom.LinkSelectionListener;

public class TextLink
extends Canvas
implements MouseListener,
MouseTrackListener,
PaintListener {
    String linkText;
    int marginWidth = 4;
    int marginHeight = 2;
    boolean mouseOver = false;
    boolean selected = false;
    LinkRenderer renderer = new DefaultLinkRenderer();
    private List listeners = new ArrayList();

    public TextLink(String linkText, Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.linkText = linkText;
        this.setBackground(parent.getBackground());
        this.addMouseListener(this);
        this.addMouseTrackListener(this);
        this.addPaintListener(this);
    }

    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public LinkRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(LinkRenderer renderer) {
        this.renderer = renderer;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.fireSelected();
        this.redraw();
    }

    public void addSelectionListener(LinkSelectionListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeSelectionListener(LinkSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelected() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((LinkSelectionListener)iterator.next()).linkSelected(this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public void mouseEnter(MouseEvent e) {
        this.mouseOver = true;
        this.redraw();
    }

    public void mouseExit(MouseEvent e) {
        this.mouseOver = false;
        this.redraw();
    }

    public void mouseHover(MouseEvent e) {
    }

    public void paintControl(PaintEvent e) {
        this.renderer.render(this, e.gc);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC g = new GC((Drawable)this);
        Point generalExtent = g.stringExtent(this.linkText);
        g.dispose();
        generalExtent.x += this.marginWidth * 2;
        generalExtent.y += this.marginHeight * 2;
        if (wHint == -1) {
            wHint = generalExtent.x;
        }
        if (hHint == -1) {
            hHint = generalExtent.y;
        }
        return new Point(wHint, hHint);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.setSelected(true);
    }

    private class DefaultLinkRenderer
    implements LinkRenderer {
        private DefaultLinkRenderer() {
        }

        public void render(TextLink link, GC g) {
            String text = link.getLinkText();
            Point textExtent = g.stringExtent(text);
            while (textExtent.x + TextLink.this.marginWidth * 2 > link.getSize().x) {
                text = String.valueOf(text.substring(0, text.length() - 4)) + "...";
                textExtent = g.stringExtent(text);
            }
            if (TextLink.this.isMouseOver()) {
                g.setBackground(link.getDisplay().getSystemColor(9));
            } else {
                g.setBackground(link.getBackground());
            }
            g.fillRectangle(0, 0, link.getSize().x, link.getSize().y);
            if (TextLink.this.isMouseOver()) {
                g.setForeground(link.getDisplay().getSystemColor(1));
            } else if (TextLink.this.isSelected()) {
                g.setForeground(link.getDisplay().getSystemColor(10));
            }
            g.drawString(text, TextLink.this.marginWidth, TextLink.this.marginHeight, true);
        }
    }
}

