/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.dialogs;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.core.project.IMediaResource;

public class PromptChooserDialog
extends Dialog {
    private String name = null;
    private String container = null;
    private Map options = null;
    private TreeViewer tree = null;

    public PromptChooserDialog(Shell parentShell, String name, String container, Map options) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.name = name;
        this.container = container;
        this.options = options;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Select a prompt");
        this.getShell().pack();
        this.getShell().setSize(250, 275);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tree = new TreeViewer(composite, 2820);
        this.tree.getControl().setLayoutData((Object)new GridData(1808));
        this.tree.setContentProvider((IContentProvider)new PromptsContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new PromptsLabelProvider());
        this.tree.setSorter(new ViewerSorter());
        this.tree.setInput((Object)this.options);
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                PromptChooserDialog.this.getButton(0).setEnabled(sel.size() == 1 && sel.getFirstElement().toString().indexOf(47) >= 0);
            }
        });
        return composite;
    }

    protected void okPressed() {
        String str = ((IStructuredSelection)this.tree.getSelection()).getFirstElement().toString();
        this.container = str.substring(0, str.indexOf(47));
        this.name = str.substring(this.container.length() + 1);
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getContainer() {
        return this.container;
    }

    private final class PromptsContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private PromptsContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return PromptChooserDialog.this.options.keySet().toArray();
        }

        public Object getParent(Object child) {
            return child instanceof IMediaResource ? ((IMediaResource)child).getParent() : null;
        }

        public Object[] getChildren(Object parent) {
            Object[] result = ((Collection)PromptChooserDialog.this.options.get(parent)).toArray();
            int i = 0;
            while (i < result.length) {
                result[i] = parent + "/" + result[i];
                ++i;
            }
            return result;
        }

        public boolean hasChildren(Object parent) {
            return parent.toString().indexOf(47) < 0;
        }

        public void dispose() {
        }
    }

    private final class PromptsLabelProvider
    extends LabelProvider {
        private PromptsLabelProvider() {
        }

        public String getText(Object obj) {
            String str = obj.toString();
            return str.substring(str.indexOf(47) + 1);
        }

        public Image getImage(Object obj) {
            if (obj.toString().indexOf(47) < 0) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
    }
}

