/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScript;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptCustomObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptFieldObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptMenuObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptMessageObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptRecordingObject;
import org.eclipse.vtp.desktop.ui.app.editor.MenuOption;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MediaScriptReader {
    private static MediaScriptReader instance = new MediaScriptReader();

    public static MediaScript load(String groupType, String instanceId, Element scriptElement) {
        CustomMediaScript ret = instance.new CustomMediaScript();
        NodeList nl = scriptElement.getElementsByTagName("dialogs");
        int i = 0;
        while (i < nl.getLength()) {
            Element entitiesElement = (Element)nl.item(i);
            NodeList entityList = entitiesElement.getElementsByTagName("dialog");
            int e = 0;
            while (e < entityList.getLength()) {
                Element optionElement;
                int o;
                Element entityElement = (Element)entityList.item(e);
                if ("field".equals(entityElement.getAttribute("type"))) {
                    ret.addDialog(new MediaScriptFieldObject(entityElement.getAttribute("name"), groupType, instanceId));
                } else if ("menu".equals(entityElement.getAttribute("type"))) {
                    NodeList optionList = entityElement.getElementsByTagName("option");
                    ArrayList<MenuOption> options = new ArrayList<MenuOption>(optionList.getLength());
                    o = 0;
                    while (o < optionList.getLength()) {
                        optionElement = (Element)optionList.item(o);
                        options.add(new MenuOption(optionElement.getAttribute("name"), Integer.parseInt(optionElement.getAttribute("dtmf"))));
                        ++o;
                    }
                    ret.addDialog(new MediaScriptMenuObject(entityElement.getAttribute("name"), groupType, instanceId, options));
                } else if ("message".equals(entityElement.getAttribute("type"))) {
                    ret.addDialog(new MediaScriptMessageObject(entityElement.getAttribute("name"), groupType, instanceId));
                } else if ("recording".equals(entityElement.getAttribute("type"))) {
                    ret.addDialog(new MediaScriptRecordingObject(entityElement.getAttribute("name"), groupType, instanceId));
                } else if ("custom".equals(entityElement.getAttribute("type"))) {
                    MediaScriptCustomObject msco = new MediaScriptCustomObject(entityElement.getAttribute("name"), entityElement.getAttribute("basetype"), groupType, instanceId);
                    NodeList optionList = entityElement.getElementsByTagName("entity");
                    o = 0;
                    while (o < optionList.getLength()) {
                        optionElement = (Element)optionList.item(o);
                        msco.addCustomEntity(optionElement.getAttribute("name"));
                        ++o;
                    }
                    ret.addDialog(msco);
                }
                ++e;
            }
            ++i;
        }
        return ret;
    }

    public class CustomMediaScript
    implements MediaScript {
        private List dialogs = new ArrayList();

        public List getDialogs() {
            return Collections.unmodifiableList(this.dialogs);
        }

        public void addDialog(MediaScriptObject dialog) {
            this.dialogs.add(dialog);
        }
    }
}

