/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationStartVariablesPropertyPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.BlankMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.VariableDeclaration;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.w3c.dom.NodeList;

public class ApplicationStartElement
extends Element
implements ConnectorOrigin {
    private List exitPoints;
    private MediaProvider mediaProvider;
    private List variableDeclarations;
    private List listeners = new ArrayList();

    public ApplicationStartElement() {
        super("Start");
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Application Start", "builtin.applicationstart.1_0_0_0");
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "Application Start", ConnectorRecord.EXIT_POINT));
        this.variableDeclarations = new ArrayList();
    }

    public ApplicationStartElement(String id) {
        super(id, "Start");
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Application Start", "builtin.applicationstart.1_0_0_0");
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "Application Start", ConnectorRecord.EXIT_POINT));
        this.variableDeclarations = new ArrayList();
    }

    public String getTagName() {
        return "app-start";
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        org.w3c.dom.Element declarationsElement = element.getOwnerDocument().createElement("declarations");
        element.appendChild(declarationsElement);
        int i = 0;
        while (i < this.variableDeclarations.size()) {
            VariableDeclaration vd = (VariableDeclaration)this.variableDeclarations.get(i);
            org.w3c.dom.Element declarationElement = declarationsElement.getOwnerDocument().createElement("variable");
            declarationsElement.appendChild(declarationElement);
            declarationElement.setAttribute("name", vd.name == null ? "" : vd.name);
            declarationElement.setAttribute("type", vd.type == null ? "" : vd.type);
            declarationElement.setAttribute("multiplicity", Integer.toString(vd.multiplicity));
            declarationElement.setAttribute("value-type", Integer.toString(vd.valueType));
            declarationElement.setAttribute("value", vd.value == null ? "" : vd.value);
            ++i;
        }
    }

    public List getHooks() {
        return this.getFreeHooks();
    }

    public List getFreeHooks() {
        return new ArrayList();
    }

    public List getExits() {
        return Collections.unmodifiableList(this.exitPoints);
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            if (cr.getConnector() != null) continue;
            freeExits.add(cr);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Application Start")) {
            return (ConnectorRecord)this.exitPoints.get(0);
        }
        return null;
    }

    public boolean hasPathToStart(List originPath) {
        return true;
    }

    public MediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public List getPropertyPanels() {
        ArrayList<VariableDeclaration> declarationsCopy = new ArrayList<VariableDeclaration>();
        int i = 0;
        while (i < this.variableDeclarations.size()) {
            declarationsCopy.add((VariableDeclaration)((VariableDeclaration)this.variableDeclarations.get(i)).clone());
            ++i;
        }
        List ret = super.getPropertyPanels();
        ret.add(new ApplicationStartVariablesPropertyPanel(this, declarationsCopy));
        return ret;
    }

    public void setVariableDeclarations(List declarations) {
        this.variableDeclarations = declarations;
        if (this.getModel() != null) {
            this.getModel().fireInternalModified();
        }
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            Variable platform = new Variable("Platform", FieldType.custom((String)"Platform", (boolean)true, (boolean)false, (int)0));
            platform.addField(new ObjectField("ANI", FieldType.STRING, true));
            platform.addField(new ObjectField("DNIS", FieldType.STRING, true));
            platform.addField(new ObjectField("Brand", FieldType.STRING, true));
            variables.add(platform);
            HashMap map = new HashMap();
            int i = 0;
            while (i < variables.size()) {
                map.put(((Variable)variables.get(i)).getName(), variables.get(i));
                ++i;
            }
            i = 0;
            while (i < this.variableDeclarations.size()) {
                VariableDeclaration vd = (VariableDeclaration)this.variableDeclarations.get(i);
                if (map.get(vd.name) == null) {
                    FieldType ft = FieldType.custom((String)vd.type, (this.isObject(vd.type) && vd.multiplicity != 1 ? 1 : 0) != 0, (vd.multiplicity == 1 ? 1 : 0) != 0, (int)0);
                    Variable v = new Variable(vd.name, ft);
                    this.buildObjectFields(v);
                    variables.add(v);
                }
                ++i;
            }
            visited.add(this.getRecord(endPointName));
        }
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isObject()) {
            List bos = ((IApplicationProject)this.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields(def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    public void readSettings(org.w3c.dom.Element configurationElement) {
        ArrayList<VariableDeclaration> vars = new ArrayList<VariableDeclaration>();
        NodeList varList = configurationElement.getElementsByTagName("variable");
        int v = 0;
        while (v < varList.getLength()) {
            org.w3c.dom.Element varElement = (org.w3c.dom.Element)varList.item(v);
            String vname = varElement.getAttribute("name");
            String vtype = varElement.getAttribute("type");
            int vmulti = varElement.getAttribute("multiplicity").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("multiplicity"));
            int vvaluetype = varElement.getAttribute("value-type").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("value-type"));
            String vvalue = varElement.getAttribute("value");
            VariableDeclaration vd = new VariableDeclaration(vname, vmulti, vtype, vvaluetype, vvalue);
            vars.add(vd);
            ++v;
        }
        this.setVariableDeclarations(vars);
    }
}

