/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElementRenderer;

public class CustomModuleUIElementRenderer
implements UIElementRenderer {
    public Rectangle calculateBounds(UIElement element, GC font) {
        Point np = font.stringExtent(element.getName());
        int nw = np.x;
        int nh = np.y;
        element.upperLeft = new java.awt.Point(element.x - (nw / 2 + 20), element.y - (nh / 2 + 10));
        element.lowerRight = new java.awt.Point(element.x + (nw / 2 + 20), element.y + (nh / 2 + 10));
        return new Rectangle(element.upperLeft.x, element.upperLeft.y, element.lowerRight.x + 15 - element.upperLeft.x, element.lowerRight.y + 15 - element.upperLeft.y);
    }

    public java.awt.Point getIncursionPoint(UIElement element, int x, int y) {
        if (element.upperLeft == null || element.lowerRight == null) {
            return null;
        }
        java.awt.Point p1 = new java.awt.Point(x, y);
        java.awt.Point p2 = new java.awt.Point(element.x, element.y);
        java.awt.Point ret = element.getIntersection(p1, p2, new java.awt.Point(element.upperLeft.x, element.upperLeft.y), new java.awt.Point(element.lowerRight.x, element.upperLeft.y));
        if (ret == null) {
            ret = element.getIntersection(p1, p2, new java.awt.Point(element.lowerRight.x, element.upperLeft.y), new java.awt.Point(element.lowerRight.x, element.lowerRight.y));
        }
        if (ret == null) {
            ret = element.getIntersection(p1, p2, new java.awt.Point(element.upperLeft.x, element.upperLeft.y), new java.awt.Point(element.upperLeft.x, element.lowerRight.y));
        }
        if (ret == null) {
            ret = element.getIntersection(p1, p2, new java.awt.Point(element.upperLeft.x, element.lowerRight.y), new java.awt.Point(element.lowerRight.x, element.lowerRight.y));
        }
        return ret;
    }

    public void paint(UIElement element, Map resourceMap, GC g, int style) {
        Color elementBlue = element.getColor(resourceMap, "COLOR_ELEMENT_BLUE", 201, 229, 255);
        Color elementGradBlue = element.getColor(resourceMap, "COLOR_ELEMENT_GRAD_BLUE", 153, 206, 255);
        Color blue = element.getColor(resourceMap, "COLOR_BLUE", 0, 0, 255);
        Color black = element.getColor(resourceMap, "COLOR_BLACK", 0, 0, 0);
        Color foreground = g.getForeground();
        Color background = g.getBackground();
        g.setBackground(elementBlue);
        g.fillRoundRectangle(element.upperLeft.x, element.upperLeft.y, element.lowerRight.x - element.upperLeft.x, element.lowerRight.y - element.upperLeft.y, 5, 5);
        if ((style & 0x200) == 0) {
            g.setBackground(elementGradBlue);
            g.fillRoundRectangle(element.upperLeft.x, element.upperLeft.y + (element.lowerRight.y - element.upperLeft.y) / 2, element.lowerRight.x - element.upperLeft.x, (element.lowerRight.y - element.upperLeft.y) / 2, 5, 5);
            g.setForeground(elementBlue);
            g.fillGradientRectangle(element.upperLeft.x, element.upperLeft.y + (element.lowerRight.y - element.upperLeft.y) / 3, element.lowerRight.x - element.upperLeft.x, (element.lowerRight.y - element.upperLeft.y) / 3 * 2 - 5, true);
            g.setForeground(foreground);
            g.setBackground(elementBlue);
        }
        if ((style & 4) == 0 && element.isSelected()) {
            g.setForeground(blue);
        } else {
            g.setForeground(black);
        }
        if ((style & 0x100) == 0) {
            g.drawRoundRectangle(element.upperLeft.x, element.upperLeft.y, element.lowerRight.x - element.upperLeft.x, element.lowerRight.y - element.upperLeft.y, 5, 5);
            if ((style & 4) == 0 && element.isSelected()) {
                g.drawRoundRectangle(element.upperLeft.x + 1, element.upperLeft.y + 1, element.lowerRight.x - element.upperLeft.x - 2, element.lowerRight.y - element.upperLeft.y - 2, 5, 5);
            }
        }
        if ((style & 2) == 0) {
            g.drawString(element.getName(), element.upperLeft.x + 30, element.upperLeft.y + 10, true);
            g.drawRectangle(new Rectangle(element.upperLeft.x + 10, element.upperLeft.y + 10, 10, 10));
        }
        if ((style & 0x10) == 0) {
            if (element.getElement().hasError()) {
                g.drawImage(UIElement.errorIcon, element.lowerRight.x - UIElement.errorIcon.getImageData().width, element.upperLeft.y);
            } else if (element.getElement().hasWarning()) {
                g.drawImage(UIElement.warningIcon, element.lowerRight.x - UIElement.warningIcon.getImageData().width, element.upperLeft.y);
            } else if (element.getElement().hasTodo()) {
                g.drawImage(UIElement.todoIcon, element.lowerRight.x - UIElement.todoIcon.getImageData().width, element.upperLeft.y);
            }
        }
        g.setForeground(foreground);
        g.setBackground(background);
    }

    public void paintShadows(UIElement element, Map resourceMap, GC g) {
        Color shadowBlue = element.getColor(resourceMap, "COLOR_SHADOW_BLUE", 201, 229, 255);
        Color background = g.getBackground();
        g.setBackground(shadowBlue);
        g.fillRoundRectangle(element.upperLeft.x + 5, element.upperLeft.y + 5, element.lowerRight.x - element.upperLeft.x, element.lowerRight.y - element.upperLeft.y, 5, 5);
        g.setBackground(background);
    }
}

