/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ForEachElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;

public class ForEachVariablePropertiesPanel
extends ComponentPropertiesPanel {
    ForEachElement forEachElement;
    TreeViewer existingVariableViewer;
    List incomingVariables;
    String varName;
    int varMulti;
    String varType;

    public ForEachVariablePropertiesPanel(ForEachElement fee) {
        super("Input Variable");
        this.forEachElement = fee;
        this.varName = fee.varName;
        this.varMulti = fee.varMulti;
        this.varType = fee.varType;
    }

    public void createControls(Composite parent) {
        this.incomingVariables = this.forEachElement.getIncomingVariables();
        final Font bold = new Font((Device)parent.getDisplay(), "Arial", 8, 1);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                bold.dispose();
            }
        });
        Label inputLabel = new Label(parent, 0);
        inputLabel.setText("Select an input variable");
        inputLabel.setFont(bold);
        inputLabel.setBackground(parent.getBackground());
        Tree existingVariableTree = new Tree(parent, 67588);
        existingVariableTree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(existingVariableTree, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(100);
        TreeColumn typeColumn = new TreeColumn(existingVariableTree, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(100);
        this.existingVariableViewer = new TreeViewer(existingVariableTree);
        this.existingVariableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.existingVariableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.existingVariableViewer.setInput((Object)this);
        parent.setLayout((Layout)new GridLayout(1, false));
        inputLabel.setLayoutData((Object)new GridData(768));
        this.existingVariableViewer.getControl().setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < this.incomingVariables.size()) {
            Variable v = (Variable)this.incomingVariables.get(i);
            if (v.getName().equals(this.varName)) {
                this.existingVariableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
            } else if (this.varName != null && this.varName.startsWith(v.getName())) {
                List objectFields = v.getFields();
                int f = 0;
                while (f < objectFields.size()) {
                    ObjectField of = (ObjectField)objectFields.get(f);
                    if (of.getPath().equals(this.varName)) {
                        this.existingVariableViewer.setSelection((ISelection)new StructuredSelection((Object)of));
                    }
                    ++f;
                }
            }
            ++i;
        }
        this.existingVariableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ObjectDefinition def = (ObjectDefinition)selection.getFirstElement();
                    ForEachVariablePropertiesPanel.this.varName = def.getName();
                    ForEachVariablePropertiesPanel.this.varMulti = def.getType().isArray() ? 1 : 0;
                    ForEachVariablePropertiesPanel.this.varType = def.getType().getTypeName();
                }
            }
        });
    }

    public void save() {
        this.forEachElement.varName = this.varName;
        this.forEachElement.varMulti = this.varMulti;
        this.forEachElement.varType = this.varType;
    }

    public class VariableContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return ForEachVariablePropertiesPanel.this.incomingVariables.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof Variable) {
                return null;
            }
            return ((ObjectField)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return true;
        }

        public Object[] getChildren(Object parentElement) {
            return ((ObjectDefinition)parentElement).getFields().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ObjectDefinition)element).getName();
            }
            FieldType ft = ((ObjectDefinition)element).getType();
            String ret = "";
            if (ft.isArray()) {
                ret = "Array Of ";
            }
            ret = String.valueOf(ret) + ft.getTypeName();
            return ret;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

