/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GridCellManager {
    HashMap byCell = new HashMap();
    HashMap byGroup = new HashMap();
    Composite managedComposite = null;

    public GridCellManager(Composite managedComposite) {
        this.managedComposite = managedComposite;
    }

    public void addCell(Control c, String groupName) {
        GridCellGroup group = (GridCellGroup)this.byGroup.get(groupName);
        if (group == null) {
            group = new GridCellGroup(groupName);
        }
        group.addCell(c);
        this.byGroup.put(groupName, group);
        ArrayList<GridCellGroup> list = (ArrayList<GridCellGroup>)this.byCell.get(c);
        if (list == null) {
            list = new ArrayList<GridCellGroup>();
        }
        list.remove(group);
        list.add(group);
        this.byCell.put(c, list);
    }

    public void addCell(Control c, String[] groupNames) {
        int i = 0;
        while (i < groupNames.length) {
            this.addCell(c, groupNames[i]);
            ++i;
        }
    }

    public void removeCell(Control c, String groupName) {
        List list;
        GridCellGroup group = (GridCellGroup)this.byGroup.get(groupName);
        if (group != null) {
            group.removeCell(c);
        }
        if ((list = (List)this.byCell.get(c)) != null) {
            list.remove(group);
        }
    }

    public void removeCell(Control c) {
        List list = (List)this.byCell.get(c);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                GridCellGroup group = (GridCellGroup)list.get(i);
                group.removeCell(c);
                ++i;
            }
        }
        this.byCell.remove(c);
    }

    public void refresh() {
        Collection groups = this.byGroup.values();
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            GridCellGroup group = (GridCellGroup)iterator.next();
            if (!group.isHidden()) continue;
            this.hideGroup(group.name);
        }
    }

    public void hideGroup(String groupName) {
        GridCellGroup group = (GridCellGroup)this.byGroup.get(groupName);
        if (group != null) {
            group.setHidden(true);
            List cells = group.getCells();
            int i = 0;
            while (i < cells.size()) {
                Control c = (Control)cells.get(i);
                c.setVisible(false);
                ((GridData)c.getLayoutData()).exclude = true;
                ++i;
            }
        }
    }

    public void showGroup(String groupName) {
        GridCellGroup group = (GridCellGroup)this.byGroup.get(groupName);
        if (group != null) {
            group.setHidden(false);
            List cells = group.getCells();
            int i = 0;
            while (i < cells.size()) {
                Control c = (Control)cells.get(i);
                List groups = (List)this.byCell.get(c);
                if (groups != null) {
                    boolean show = true;
                    int g = 0;
                    while (g < groups.size()) {
                        GridCellGroup gr = (GridCellGroup)groups.get(g);
                        if (gr != null) {
                            show &= !gr.isHidden();
                        }
                        ++g;
                    }
                    if (show) {
                        c.setVisible(true);
                        ((GridData)c.getLayoutData()).exclude = false;
                    }
                }
                ++i;
            }
        }
    }

    class GridCellGroup {
        String name = "";
        boolean hidden = false;
        List cells = new ArrayList();

        public GridCellGroup(String name) {
            this.name = name;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public void addCell(Control c) {
            this.cells.remove(c);
            this.cells.add(c);
        }

        public void removeCell(Control c) {
            this.cells.remove(c);
        }

        public List getCells() {
            return this.cells;
        }
    }
}

