/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuChoice;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuElementPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.NodeList;

public class MenuElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    List incomingConnectors;
    List exitPoints;
    boolean barginEnabled;
    List menuChoices;
    private List listeners = new ArrayList();
    boolean retriesSeparate = false;
    int noInputLimit = 2;
    int noMatchLimit = 2;
    int badInputLimit = 2;
    Map brandOrders = new HashMap();

    public MenuElement(String name) {
        super(name);
        this.incomingConnectors = new ArrayList();
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "error.input.nomatch", ConnectorRecord.ERROR_POINT));
        this.exitPoints.add(new ConnectorRecord(this, "error.input.noinput", ConnectorRecord.ERROR_POINT));
        this.menuChoices = new ArrayList();
    }

    public MenuElement(String id, String name) {
        super(id, name);
        this.incomingConnectors = new ArrayList();
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "error.input.nomatch", ConnectorRecord.ERROR_POINT));
        this.exitPoints.add(new ConnectorRecord(this, "error.input.noinput", ConnectorRecord.ERROR_POINT));
        this.menuChoices = new ArrayList();
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public boolean isBarginEnabled() {
        return this.barginEnabled;
    }

    public void setBarginEnabled(boolean barginEnabled) {
        this.barginEnabled = barginEnabled;
    }

    public ConnectorRecord getRecord(String name) {
        int i = 0;
        while (i < this.exitPoints.size()) {
            if (((ConnectorRecord)this.exitPoints.get(i)).getName().equals(name)) {
                return (ConnectorRecord)this.exitPoints.get(i);
            }
            ++i;
        }
        return null;
    }

    public List getHooks() {
        return this.getFreeHooks();
    }

    public List getFreeHooks() {
        return Collections.unmodifiableList(new ArrayList());
    }

    public List getExits() {
        ArrayList<ConnectorRecord> exits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            exits.add(cr);
        }
        return Collections.unmodifiableList(exits);
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            if (cr.getConnector() != null) continue;
            freeExits.add(cr);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        int i = 0;
        while (i < this.exitPoints.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.exitPoints.get(i);
            if (cr.getType() == ConnectorRecord.ERROR_POINT) {
                hasErrorFrom = true;
            }
            if (cr.getConnector() != null) {
                if (cr.getType() == ConnectorRecord.EXIT_POINT) {
                    isExitedFrom = true;
                } else {
                    isErrorFrom = true;
                }
            }
            ++i;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<MenuElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public String getTagName() {
        return "menu";
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("barge-in", this.barginEnabled ? "true" : "false");
        element.setAttribute("retry-strategy", this.retriesSeparate ? "separate" : "combined");
        element.setAttribute("no-input-limit", Integer.toString(this.noInputLimit));
        element.setAttribute("no-match-limit", Integer.toString(this.noMatchLimit));
        element.setAttribute("bad-input-limit", Integer.toString(this.badInputLimit));
        org.w3c.dom.Element choicesElement = element.getOwnerDocument().createElement("choices");
        element.appendChild(choicesElement);
        int i = 0;
        while (i < this.menuChoices.size()) {
            MenuChoice mc = (MenuChoice)this.menuChoices.get(i);
            org.w3c.dom.Element choiceElement = element.getOwnerDocument().createElement("choice");
            choiceElement.setAttribute("name", mc.getOptionName());
            choicesElement.appendChild(choiceElement);
            ++i;
        }
        Iterator iterator = this.brandOrders.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            org.w3c.dom.Element orderElement = element.getOwnerDocument().createElement("brand-order");
            orderElement.setAttribute("brand", (String)entry.getKey());
            element.appendChild(orderElement);
            List options = (List)entry.getValue();
            int i2 = 0;
            while (i2 < options.size()) {
                MenuChoice mc = (MenuChoice)options.get(i2);
                org.w3c.dom.Element orderEntryElement = element.getOwnerDocument().createElement("entry");
                orderEntryElement.setAttribute("name", mc.getOptionName());
                orderEntryElement.setAttribute("spot", Integer.toString(i2));
                orderElement.appendChild(orderEntryElement);
                ++i2;
            }
        }
    }

    public void readSettings(org.w3c.dom.Element element) {
        MenuChoice mc;
        if (!element.getAttribute("retry-strategy").equals("")) {
            this.retriesSeparate = element.getAttribute("retry-strategy").equals("separate");
        }
        if (!element.getAttribute("no-input-limit").equals("")) {
            try {
                this.noInputLimit = Integer.parseInt(element.getAttribute("no-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("no-match-limit").equals("")) {
            try {
                this.noMatchLimit = Integer.parseInt(element.getAttribute("no-match-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("bad-input-limit").equals("")) {
            try {
                this.badInputLimit = Integer.parseInt(element.getAttribute("bad-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        try {
            org.w3c.dom.Element[] choices = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)element, (String)"choices"));
            int ch = 0;
            while (ch < choices.length) {
                MenuChoice mc2 = new MenuChoice(choices[ch].getAttribute("name"), choices[ch].getAttribute("dtmf"), choices[ch].getAttribute("silent").equals("true"));
                this.menuChoices.add(mc2);
                this.exitPoints.add(new ConnectorRecord(this, mc2.getOptionName(), ConnectorRecord.EXIT_POINT));
                ++ch;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NodeList brandOrdersList = element.getElementsByTagName("brand-order");
        if (brandOrdersList.getLength() == 0) {
            ArrayList<MenuChoice> defaultList = new ArrayList<MenuChoice>();
            int i = 0;
            while (i < this.menuChoices.size()) {
                mc = (MenuChoice)this.menuChoices.get(i);
                defaultList.add(mc);
                ++i;
            }
            this.brandOrders.put("Default", defaultList);
        }
        int i = 0;
        while (i < brandOrdersList.getLength()) {
            ArrayList<MenuChoice> brandList = new ArrayList<MenuChoice>();
            org.w3c.dom.Element brandOrderElement = (org.w3c.dom.Element)brandOrdersList.item(i);
            String brandName = brandOrderElement.getAttribute("brand");
            NodeList entryList = brandOrderElement.getElementsByTagName("entry");
            int e = 0;
            while (e < entryList.getLength()) {
                org.w3c.dom.Element entryElement = (org.w3c.dom.Element)entryList.item(e);
                int x = 0;
                while (x < this.menuChoices.size()) {
                    MenuChoice mc3 = (MenuChoice)this.menuChoices.get(x);
                    if (mc3.getOptionName().equals(entryElement.getAttribute("name"))) {
                        brandList.add(mc3);
                        break;
                    }
                    ++x;
                }
                ++e;
            }
            this.brandOrders.put(brandName, brandList);
            ++i;
        }
        if (this.brandOrders.get("Default") == null) {
            ArrayList<MenuChoice> defaultList = new ArrayList<MenuChoice>();
            int i2 = 0;
            while (i2 < this.menuChoices.size()) {
                mc = (MenuChoice)this.menuChoices.get(i2);
                defaultList.add(mc);
                ++i2;
            }
            this.brandOrders.put("Default", defaultList);
        }
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new MenuElementPropertiesPanel(this));
        return ret;
    }

    public MediaProvider getMediaProvider() {
        return new MenuMediaProvider(this);
    }

    public MenuChoice addChoice(String brand, MenuChoice choice) {
        ArrayList orderList = (ArrayList)this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList();
            List defaultList = (List)this.brandOrders.get("Default");
            int i = 0;
            while (i < defaultList.size()) {
                orderList.add(defaultList.get(i));
                ++i;
            }
            this.brandOrders.put(brand, orderList);
        }
        int i = 0;
        while (i < this.menuChoices.size()) {
            MenuChoice mc = (MenuChoice)this.menuChoices.get(i);
            if (mc.getOptionName().equals(choice.getOptionName())) {
                orderList.add(mc);
                return mc;
            }
            ++i;
        }
        this.menuChoices.add(choice);
        orderList.add(choice);
        this.exitPoints.add(new ConnectorRecord(this, choice.getOptionName(), ConnectorRecord.EXIT_POINT));
        return choice;
    }

    public void moveChoiceUp(String brand, MenuChoice choice) {
        int index;
        ArrayList orderList = (ArrayList)this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList();
            List defaultList = (List)this.brandOrders.get("Default");
            int i = 0;
            while (i < defaultList.size()) {
                orderList.add(defaultList.get(i));
                ++i;
            }
            this.brandOrders.put(brand, orderList);
        }
        if ((index = orderList.indexOf(choice)) > 0) {
            orderList.remove(index);
            orderList.add(index - 1, choice);
        }
    }

    public void moveChoiceDown(String brand, MenuChoice choice) {
        System.out.println("brand: " + brand);
        ArrayList orderList = (ArrayList)this.brandOrders.get(brand);
        if (orderList == null) {
            System.out.println("loading default list");
            orderList = new ArrayList();
            List defaultList = (List)this.brandOrders.get("Default");
            int i = 0;
            while (i < defaultList.size()) {
                orderList.add(defaultList.get(i));
                ++i;
            }
            this.brandOrders.put(brand, orderList);
        }
        int index = orderList.indexOf(choice);
        System.out.println("index: " + index);
        if (index < orderList.size() - 1) {
            orderList.remove(index);
            orderList.add(index + 1, choice);
        }
    }

    public void removeChoice(String brand, MenuChoice choice) {
        ArrayList orderList = (ArrayList)this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList();
            List defaultList = (List)this.brandOrders.get("Default");
            int i = 0;
            while (i < defaultList.size()) {
                orderList.add(defaultList.get(i));
                ++i;
            }
            this.brandOrders.put(brand, orderList);
        }
        orderList.remove(choice);
        Iterator iterator = this.brandOrders.entrySet().iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List mcList = (List)entry.getValue();
            if (!mcList.contains(choice)) continue;
            found = true;
        }
        if (!found) {
            this.menuChoices.remove(choice);
            int i = 0;
            while (i < this.exitPoints.size()) {
                ConnectorRecord cr = (ConnectorRecord)this.exitPoints.get(i);
                if (cr.getName().equals(choice.getOptionName())) {
                    if (cr.getConnector() != null) {
                        this.getModel().deleteConnector(cr.getConnector());
                    }
                    this.exitPoints.remove(cr);
                    break;
                }
                ++i;
            }
        }
    }

    public void updateChoice(MenuChoice choice, String oldName) {
        int i = 0;
        while (i < this.exitPoints.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.exitPoints.get(i);
            if (cr.getName().equals(oldName)) {
                cr.setName(choice.getOptionName());
                break;
            }
            ++i;
        }
    }

    public List getChoices() {
        return Collections.unmodifiableList(this.menuChoices);
    }

    public List getChoicesByBrand(String brand) {
        System.out.println("brand: " + brand);
        Object obj = this.brandOrders.get(brand);
        if (obj == null) {
            System.out.println("default list");
            obj = this.brandOrders.get("Default");
            if (obj == null) {
                System.out.println("empty menu");
                obj = new ArrayList();
                this.brandOrders.put("Default", obj);
            }
        }
        return Collections.unmodifiableList((List)obj);
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }
}

