/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.SubdialogPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.NodeList;

public class SubdialogElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    List incomingConnectors;
    ConnectorRecord next = new ConnectorRecord(this, "Continue", ConnectorRecord.EXIT_POINT);
    ConnectorRecord error = new ConnectorRecord(this, "error.subdialog", ConnectorRecord.ERROR_POINT);
    private List listeners = new ArrayList();
    private List inputs = new ArrayList();
    private List outputs = new ArrayList();
    private String url = "";

    public SubdialogElement(String name) {
        super(name);
        this.incomingConnectors = new ArrayList();
    }

    public SubdialogElement(String id, String name) {
        super(id, name);
        this.incomingConnectors = new ArrayList();
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Continue")) {
            return this.next;
        }
        if (name.equals("error.subdialog")) {
            return this.error;
        }
        return null;
    }

    public List getHooks() {
        return new ArrayList();
    }

    public List getFreeHooks() {
        ArrayList freeExits = new ArrayList();
        return Collections.unmodifiableList(freeExits);
    }

    public List getExits() {
        return Collections.unmodifiableList(Arrays.asList(this.next, this.error));
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        if (this.next.getConnector() == null) {
            freeExits.add(this.next);
        }
        if (this.error.getConnector() == null) {
            freeExits.add(this.error);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        if (this.next.getConnector() != null) {
            isExitedFrom = true;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<SubdialogElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("url", XMLUtilities.encodeAttribute((String)this.url));
        org.w3c.dom.Element inputsElement = element.getOwnerDocument().createElement("inputs");
        element.appendChild(inputsElement);
        int i = 0;
        while (i < this.inputs.size()) {
            SubdialogInput si = (SubdialogInput)this.inputs.get(i);
            org.w3c.dom.Element inputElement = element.getOwnerDocument().createElement("input");
            inputsElement.appendChild(inputElement);
            inputElement.setAttribute("name", si.name);
            inputElement.setAttribute("type", Integer.toString(si.type));
            inputElement.setAttribute("value", si.value);
            ++i;
        }
        org.w3c.dom.Element outputsElement = element.getOwnerDocument().createElement("outputs");
        element.appendChild(outputsElement);
        int i2 = 0;
        while (i2 < this.outputs.size()) {
            SubdialogOutput so = (SubdialogOutput)this.outputs.get(i2);
            org.w3c.dom.Element outputElement = element.getOwnerDocument().createElement("output");
            outputsElement.appendChild(outputElement);
            outputElement.setAttribute("name", so.varName);
            outputElement.setAttribute("value", so.valueName);
            ++i2;
        }
    }

    public void readSettings(org.w3c.dom.Element element) {
        int i;
        this.url = element.getAttribute("url");
        NodeList nl = element.getElementsByTagName("inputs");
        if (nl.getLength() > 0) {
            org.w3c.dom.Element inputsElement = (org.w3c.dom.Element)nl.item(0);
            nl = inputsElement.getElementsByTagName("input");
            i = 0;
            while (i < nl.getLength()) {
                org.w3c.dom.Element inputElement = (org.w3c.dom.Element)nl.item(i);
                String inputName = inputElement.getAttribute("name");
                int inputType = Integer.parseInt(inputElement.getAttribute("type"));
                String inputValue = inputElement.getAttribute("value");
                this.inputs.add(new SubdialogInput(inputName, inputType, inputValue));
                ++i;
            }
        }
        if ((nl = element.getElementsByTagName("outputs")).getLength() > 0) {
            org.w3c.dom.Element outputsElement = (org.w3c.dom.Element)nl.item(0);
            nl = outputsElement.getElementsByTagName("output");
            i = 0;
            while (i < nl.getLength()) {
                org.w3c.dom.Element outputElement = (org.w3c.dom.Element)nl.item(i);
                String varName = outputElement.getAttribute("name");
                String valueName = outputElement.getAttribute("value");
                this.outputs.add(new SubdialogOutput(varName, valueName));
                ++i;
            }
        }
    }

    public List getInputs() {
        return this.inputs;
    }

    public void setInputs(List inputs) {
        this.inputs = inputs;
    }

    public List getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List outputs) {
        this.outputs = outputs;
    }

    public MediaProvider getMediaProvider() {
        return null;
    }

    public String getTagName() {
        return "subdialog";
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new SubdialogPropertiesPanel(this));
        return ret;
    }

    public List getIncomingVariables() {
        ArrayList ret = new ArrayList();
        ArrayList visited = new ArrayList();
        this.getVariables("", ret, visited);
        return ret;
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
            if (endPointName.equals("Continue")) {
                i = 0;
                while (i < this.outputs.size()) {
                    SubdialogOutput so = (SubdialogOutput)this.outputs.get(i);
                    variables.add(new Variable(so.varName, FieldType.STRING));
                    ++i;
                }
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    public class SubdialogInput {
        String name = "";
        int type = 0;
        String value = "";

        public SubdialogInput(String name, int type, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }
    }

    public class SubdialogOutput {
        String varName = "";
        String valueName = "";

        public SubdialogOutput(String varName, String valueName) {
            this.varName = varName;
            this.valueName = valueName;
        }
    }
}

