/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.Iterator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.TransferElement;

public class TransferPropertiesPanel
extends ComponentPropertiesPanel {
    TransferElement me;
    Label nameLabel;
    Text nameField;
    private Button valueButton;
    private Text valueText;
    private Button variableButton;
    private Combo variableCombo;

    public TransferPropertiesPanel(TransferElement me) {
        super("General");
        this.me = me;
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(2, false));
        this.valueButton = new Button(comp, 16);
        this.valueButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.valueButton.setText("Use a value:");
        this.valueText = new Text(comp, 2048);
        this.valueText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.me.getTargetType() == 0) {
            this.valueButton.setSelection(true);
            this.valueText.setText(this.me.getTarget());
        }
        this.variableButton = new Button(comp, 16);
        this.variableButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.variableButton.setText("Use a variable:");
        this.variableCombo = new Combo(comp, 4);
        this.variableCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        Iterator i = this.me.getVariables().iterator();
        while (i.hasNext()) {
            ObjectDefinition def = (ObjectDefinition)i.next();
            System.out.println(def.getType().getTypeName());
            if (def.getType().getTypeName().equals("String") || def.getType().getTypeName().equals("Number")) {
                this.variableCombo.add(def.getName());
                continue;
            }
            Iterator j = def.getFields().iterator();
            while (j.hasNext()) {
                ObjectField field = (ObjectField)j.next();
                if (!field.getType().getTypeName().equals("String") && !field.getType().getTypeName().equals("Number")) continue;
                this.variableCombo.add(field.getPath());
            }
        }
        if (this.me.getTargetType() == 1) {
            this.variableButton.setSelection(true);
            this.variableCombo.select(this.variableCombo.indexOf(this.me.getTarget()));
        }
    }

    public void save() {
        if (this.valueButton.getSelection()) {
            this.me.setTarget(this.valueText.getText());
            this.me.setTargetType(0);
        } else {
            this.me.setTarget(this.variableCombo.getItem(this.variableCombo.getSelectionIndex()));
            this.me.setTargetType(1);
        }
        this.me.setName("Transfer: " + this.me.getTarget());
    }
}

