/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelPage;
import org.eclipse.vtp.desktop.ui.app.editor.model.Locatable;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIComponentListener;

public abstract class UIComponent {
    private List listeners = new ArrayList();
    private ApplicationModelPage page;

    public ApplicationModelPage getModelPage() {
        return this.page;
    }

    protected void setModelPage(ApplicationModelPage page) {
        this.page = page;
    }

    public boolean contains(int x, int y) {
        return false;
    }

    public List getPropertyPanels() {
        return new ArrayList();
    }

    public void addListener(UIComponentListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(UIComponentListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireUpdateRequest() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((UIComponentListener)iterator.next()).updateRequested(this);
        }
    }

    protected void fireUpdateStatusRequest() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((UIComponentListener)iterator.next()).updateStatusRequested(this);
        }
    }

    protected void fireModifiedRequest() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UIComponentListener ucl = (UIComponentListener)iterator.next();
            ucl.modifiedRequest(this);
        }
    }

    public void fillContextMenu(int eventX, int eventY, JPopupMenu popup) {
    }

    public Locatable getLocatable(int x, int y) {
        return null;
    }

    public void delete() {
    }

    public String getToolTip() {
        return null;
    }

    public abstract Rectangle calculateBounds(GC var1);
}

