/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.awt.Point;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.eclipse.vtp.desktop.ui.app.editor.model.DefaultUIElementRenderer;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.IncursionHost;
import org.eclipse.vtp.desktop.ui.app.editor.model.Locatable;
import org.eclipse.vtp.desktop.ui.app.editor.model.Selectable;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIComponent;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElementRenderer;

public class UIElement
extends UIComponent
implements Selectable,
Locatable,
IncursionHost {
    public static Image errorIcon = ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_ERROR");
    public static Image warningIcon = ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_WARNING");
    public static Image todoIcon = ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_TASK");
    protected int x;
    protected int y;
    private boolean selected = false;
    protected Point upperLeft;
    protected Point lowerRight;
    private Element element;
    private UIElementRenderer renderer = new DefaultUIElementRenderer();

    public UIElement(Element element) {
        this.element = element;
        this.x = 40;
        this.y = 40;
    }

    public Point getLowerRight() {
        return this.lowerRight;
    }

    public Point getUpperLeft() {
        return this.upperLeft;
    }

    public String getId() {
        return this.element.getId();
    }

    public Element getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public void setName(String name) {
        this.element.setName(name);
        this.fireUpdateRequest();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setLocation(int x, int y) {
        int dx = x - this.x;
        int dy = y - this.y;
        this.x = x;
        this.y = y;
        if (this.upperLeft != null) {
            this.upperLeft.x += dx;
            this.upperLeft.y += dy;
        }
        if (this.lowerRight != null) {
            this.lowerRight.x += dx;
            this.lowerRight.y += dy;
        }
    }

    public void paint(Map resourceMap, GC g, int style) {
        if (this.upperLeft == null || this.lowerRight == null) {
            this.calculateBounds(g);
        }
        this.renderer.paint(this, resourceMap, g, style);
    }

    public void paintShadows(Map resourceMap, GC g) {
        if (this.upperLeft == null || this.lowerRight == null) {
            this.calculateBounds(g);
        }
        this.renderer.paintShadows(this, resourceMap, g);
    }

    public Color getColor(Map resourceMap, String name, int r, int g, int b) {
        Object obj = resourceMap.get(name);
        if (obj != null) {
            return (Color)obj;
        }
        Color c = new Color((Device)Display.getCurrent(), r, g, b);
        resourceMap.put(name, c);
        return c;
    }

    public boolean contains(int x, int y) {
        return x >= this.upperLeft.x && x <= this.lowerRight.x && y >= this.upperLeft.y && y <= this.lowerRight.y;
    }

    public boolean containedIn(Rectangle rect) {
        Rectangle bounds = new Rectangle(this.upperLeft.x, this.upperLeft.y, this.lowerRight.x - this.upperLeft.x, this.lowerRight.y - this.upperLeft.y);
        return bounds.intersects(rect);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setRenderer(UIElementRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("Renderer cannot be null.");
        }
        this.renderer = renderer;
    }

    public Point getIncursionPoint(int x, int y) {
        return this.renderer.getIncursionPoint(this, x, y);
    }

    public Point getRegistryPoint() {
        return new Point(this.x, this.y);
    }

    protected Point getIntersection(Point p1, Point p2, Point p3, Point p4) {
        double x1 = p1.x;
        double y1 = p1.y;
        double x2 = p2.x;
        double y2 = p2.y;
        double x3 = p3.x;
        double y3 = p3.y;
        double x4 = p4.x;
        double y4 = p4.y;
        double uan = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
        double ud = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (ud == 0.0) {
            return null;
        }
        double ua = uan / ud;
        double ubn = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
        double ub = ubn / ud;
        if (ua <= 0.0 || ua >= 1.0 || ub <= 0.0 || ub >= 1.0) {
            return null;
        }
        double ix = x1 + ua * (x2 - x1);
        double iy = y1 + ua * (y2 - y1);
        return new Point((int)ix, (int)iy);
    }

    public Locatable getLocatable(int x, int y) {
        if (this.contains(x, y)) {
            return this;
        }
        return super.getLocatable(x, y);
    }

    public void writeToDocument(org.w3c.dom.Element parent) {
        org.w3c.dom.Element element = parent.getOwnerDocument().createElement(this.getTagName());
        parent.appendChild(element);
        this.writeAttributes(element);
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        element.setAttribute("instance-id", this.getId());
        element.setAttribute("x", Integer.toString(this.getX()));
        element.setAttribute("y", Integer.toString(this.getY()));
    }

    public String getTagName() {
        return "ui-element";
    }

    public List getPropertyPanels() {
        return this.element.getPropertyPanels();
    }

    public Rectangle calculateBounds(GC font) {
        return this.renderer.calculateBounds(this, font);
    }
}

