/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IWebService;
import org.eclipse.vtp.desktop.core.project.IWebServiceOperation;
import org.eclipse.vtp.desktop.core.project.IWebServicePort;
import org.eclipse.vtp.desktop.core.project.IWebServiceSet;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallSettingsStructure;

public class WebServiceCallServicePropertiesPanel
extends ComponentPropertiesPanel
implements SelectionListener {
    private final WebServiceCallElement callElement;
    private final WebServiceCallSettingsStructure settings;
    private Combo webServiceCombo = null;
    private Combo portTypeCombo = null;
    private Combo operationCombo = null;
    private IWebServiceSet webServiceSet = null;

    public WebServiceCallServicePropertiesPanel(WebServiceCallElement wsce, WebServiceCallSettingsStructure settings) {
        super("Service");
        this.callElement = wsce;
        this.settings = settings;
    }

    private void reset() {
        this.portTypeCombo.removeAll();
        this.operationCombo.removeAll();
        List portTypes = this.webServiceSet.getWebService(this.settings.sourceWebService).getWebServicePorts();
        int selected = -1;
        int index = 0;
        Iterator i = portTypes.iterator();
        while (i.hasNext()) {
            String portName = ((IWebServicePort)i.next()).getName();
            this.portTypeCombo.add(portName);
            if (portName.equals(this.settings.sourceWebServicePort)) {
                selected = index;
            }
            ++index;
        }
        if (selected < 0) {
            return;
        }
        this.portTypeCombo.select(selected);
        List operations = this.webServiceSet.getWebService(this.settings.sourceWebService).getWebServicePort(this.settings.sourceWebServicePort).getWebServiceOperations();
        selected = -1;
        index = 0;
        Iterator i2 = operations.iterator();
        while (i2.hasNext()) {
            String operationName = ((IWebServiceOperation)i2.next()).getName();
            this.operationCombo.add(operationName);
            if (operationName.equals(this.settings.sourceWebServiceOperation)) {
                selected = index;
            }
            ++index;
        }
        if (selected < 0) {
            return;
        }
        this.operationCombo.select(selected);
    }

    public void createControls(Composite parent) {
        this.webServiceSet = ((IApplicationProject)this.callElement.getModel().getApplication().getProject()).getWebServiceSet();
        List webServices = this.webServiceSet.getWebServices();
        if (webServices.size() > 0) {
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 10;
            gl.marginWidth = 20;
            parent.setLayout((Layout)gl);
            Label webServiceLabel = new Label(parent, 0);
            webServiceLabel.setText("Web Service:");
            webServiceLabel.setBackground(parent.getBackground());
            webServiceLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.webServiceCombo = new Combo(parent, 12);
            this.webServiceCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.webServiceCombo.addSelectionListener((SelectionListener)this);
            Label portTypeLabel = new Label(parent, 0);
            portTypeLabel.setText("Port Type:");
            portTypeLabel.setBackground(parent.getBackground());
            portTypeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.portTypeCombo = new Combo(parent, 12);
            this.portTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.portTypeCombo.addSelectionListener((SelectionListener)this);
            Label operationLabel = new Label(parent, 0);
            operationLabel.setText("Operation:");
            operationLabel.setBackground(parent.getBackground());
            operationLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.operationCombo = new Combo(parent, 12);
            this.operationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.operationCombo.addSelectionListener((SelectionListener)this);
            int selected = -1;
            int index = 0;
            Iterator i = webServices.iterator();
            while (i.hasNext()) {
                String wsName = ((IWebService)i.next()).getName();
                this.webServiceCombo.add(wsName);
                if (wsName.equals(this.settings.sourceWebService)) {
                    selected = index;
                }
                ++index;
            }
            if (selected >= 0) {
                this.webServiceCombo.select(selected);
                this.reset();
            }
        } else {
            parent.setLayout((Layout)new GridLayout());
            Label noWebServicesLabel = new Label(parent, 0);
            noWebServicesLabel.setText("You must first create a web service to call.");
            noWebServicesLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        }
    }

    public void save() {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.webServiceCombo == e.getSource()) {
            this.settings.sourceWebService = this.webServiceCombo.getItem(this.webServiceCombo.getSelectionIndex());
        } else if (this.portTypeCombo == e.getSource()) {
            this.settings.sourceWebServicePort = this.portTypeCombo.getItem(this.portTypeCombo.getSelectionIndex());
            this.settings.sourceWebServiceLocator = String.valueOf(this.webServiceSet.getWebService(this.settings.sourceWebService).getWebServicePort(this.settings.sourceWebServicePort).getServiceName()) + "Locator";
        } else if (this.operationCombo == e.getSource()) {
            this.settings.sourceWebServiceOperation = this.operationCombo.getItem(this.operationCombo.getSelectionIndex());
        } else {
            return;
        }
        this.settings.fireSourceChanged();
        this.reset();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

