/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.BlankMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeExitElement;

public class WormholeEntryElement
extends Element
implements ConnectorDestination {
    private List incomingConnectors = new ArrayList();
    private MediaProvider mediaProvider = new BlankMediaProvider(this.getId(), "WormholeEntry", "buildin.genesys.transfer.1_0_0_0");
    private WormholeExitElement exitElement;

    public WormholeEntryElement(String name) {
        super(name);
    }

    public WormholeEntryElement(String id, String name) {
        super(id, name);
    }

    protected void setExitElement(WormholeExitElement element) {
        this.exitElement = element;
        if (element != null) {
            this.setName(element.getName());
        } else {
            this.setName("?");
        }
    }

    public void delete() {
        super.delete();
        if (this.exitElement != null) {
            this.exitElement.removeWormholeEntry(this);
        }
    }

    public MediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public void validateStatus() {
        super.validateStatus();
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<WormholeEntryElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public String getTagName() {
        return "worm-hole-entry";
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("exit-id", this.exitElement == null ? "" : this.exitElement.getId());
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new WormholeEntryPropPanel());
        return ret;
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this)) {
            visited.add(this);
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public class WormholeEntryPropPanel
    extends ComponentPropertiesPanel {
        Combo exitCombo;

        public WormholeEntryPropPanel() {
            super("General");
            this.exitCombo = null;
        }

        public void createControls(Composite parent) {
            List wormholes = WormholeEntryElement.this.getModel().listWormholes();
            Label hostLabel = new Label(parent, 0);
            if (wormholes.size() > 0) {
                hostLabel.setText("Select the exit point:");
            } else {
                hostLabel.setText("There are no current exit points.  Press finish to continue.");
            }
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            parent.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 10);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 10 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            if (wormholes.size() > 0) {
                this.exitCombo = new Combo(parent, 12);
                Iterator iterator = wormholes.iterator();
                while (iterator.hasNext()) {
                    this.exitCombo.add(((WormholeExitElement)iterator.next()).getName());
                }
                this.exitCombo.select(0);
                FormData hostFieldFormData = new FormData();
                hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
                hostFieldFormData.top = new FormAttachment(0, 10);
                hostFieldFormData.right = new FormAttachment(100, -10);
                this.exitCombo.setLayoutData((Object)hostFieldFormData);
            }
        }

        public void save() {
            WormholeEntryElement.this.exitElement.removeWormholeEntry(WormholeEntryElement.this);
            ((WormholeExitElement)WormholeEntryElement.this.getModel().listWormholes().get(this.exitCombo.getSelectionIndex())).addWormholeEntry(WormholeEntryElement.this);
        }
    }
}

