/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.BlankMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeEntryElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;

public class WormholeExitElement
extends Element
implements ConnectorOrigin {
    private MediaProvider mediaProvider = null;
    private List exitPoints;
    private List entryList = new ArrayList();
    private List listeners = new ArrayList();

    public WormholeExitElement(String name) {
        super(name);
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Wormhole Exit", "Wormhole Exit");
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "Continue", ConnectorRecord.EXIT_POINT));
    }

    public WormholeExitElement(String id, String name) {
        super(id, name);
        this.mediaProvider = new BlankMediaProvider(id, "Wormhole Exit", "Wormhole Exit");
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "Continue", ConnectorRecord.EXIT_POINT));
    }

    public MediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public void addWormholeEntry(WormholeEntryElement entryElement) {
        this.entryList.remove(entryElement);
        this.entryList.add(entryElement);
        entryElement.setExitElement(this);
    }

    public void removeWormholeEntry(WormholeEntryElement entryElement) {
        this.entryList.remove(entryElement);
        entryElement.setExitElement(null);
    }

    public void delete() {
        super.delete();
        Iterator iterator = this.entryList.iterator();
        while (iterator.hasNext()) {
            ((WormholeEntryElement)iterator.next()).setExitElement(null);
        }
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Continue")) {
            return (ConnectorRecord)this.exitPoints.get(0);
        }
        return null;
    }

    public List getHooks() {
        return this.getFreeHooks();
    }

    public List getFreeHooks() {
        return new ArrayList();
    }

    public List getExits() {
        ArrayList<ConnectorRecord> exits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            exits.add(cr);
        }
        return Collections.unmodifiableList(exits);
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            if (cr.getConnector() != null) continue;
            freeExits.add(cr);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        if (!this.hasPathToStart(null)) {
            this.setError(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<WormholeExitElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.entryList.size()) {
            boolean has;
            WormholeEntryElement connector = (WormholeEntryElement)this.entryList.get(i);
            if (!originPath.contains(connector) && (ret |= (has = connector.hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public String getTagName() {
        return "worm-hole-exit";
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.entryList.size()) {
                WormholeEntryElement wee = (WormholeEntryElement)this.entryList.get(i);
                wee.getVariables(endPointName, variables, visited);
                ++i;
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        int i = 0;
        while (i < this.entryList.size()) {
            WormholeEntryElement wee = (WormholeEntryElement)this.entryList.get(i);
            ret.addAll(wee.getVariables());
            ++i;
        }
        return ret;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    public class WormholeExitPropPanel
    extends ComponentPropertiesPanel {
        Text nameField;

        public WormholeExitPropPanel() {
            super("General");
        }

        public void createControls(Composite parent) {
            Label hostLabel = new Label(parent, 0);
            hostLabel.setText("Wormhole Name:");
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            this.nameField = new Text(parent, 2052);
            this.nameField.setTextLimit(2);
            this.nameField.addModifyListener(new ModifyListener(this){
                final /* synthetic */ WormholeExitPropPanel this$1;
                {
                    this.this$1 = wormholeExitPropPanel;
                }

                public void modifyText(ModifyEvent e) {
                    String n = this.this$1.nameField.getText();
                    Iterator<E> iterator = WormholeExitPropPanel.access$0(this.this$1).getModel().listWormholes().iterator();
                    while (iterator.hasNext()) {
                        if (!((WormholeExitElement)iterator.next()).getName().equals(n)) continue;
                        return;
                    }
                }
            });
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            parent.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 10);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 10 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            FormData hostFieldFormData = new FormData();
            hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
            hostFieldFormData.top = new FormAttachment(0, 10);
            hostFieldFormData.right = new FormAttachment(100, -10);
            this.nameField.setLayoutData((Object)hostFieldFormData);
        }

        public void save() {
            WormholeExitElement.this.setName(this.nameField.getText());
        }

        static /* synthetic */ WormholeExitElement access$0(WormholeExitPropPanel wormholeExitPropPanel) {
            return wormholeExitPropPanel.WormholeExitElement.this;
        }
    }
}

