/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElementRenderer;

public class WormholeExitRenderer
implements UIElementRenderer {
    public java.awt.Point getIncursionPoint(UIElement element, int x, int y) {
        if (element.getUpperLeft() == null) {
            return new java.awt.Point(element.x, element.y);
        }
        int r = element.getX() - element.getUpperLeft().x;
        double d = Math.sqrt(Math.pow(x - element.getX(), 2.0) + Math.pow(element.getY() - y, 2.0));
        return new java.awt.Point(element.x + (int)((double)((float)r * (float)(x - element.getX())) / d), element.y + (int)((double)r * ((double)(-1.0f * (float)(element.getY() - y)) / d)));
    }

    public Rectangle calculateBounds(UIElement element, GC font) {
        Point np = font.stringExtent(element.getName());
        int nw = np.x;
        int nh = np.y;
        int r = Math.max(nw / 2 + 10, nh / 2 + 10);
        element.upperLeft = new java.awt.Point(element.x - r, element.y - r);
        element.lowerRight = new java.awt.Point(element.x + r, element.y + r);
        return new Rectangle(element.upperLeft.x, element.upperLeft.y, element.lowerRight.x + 15 - element.upperLeft.x, element.lowerRight.y + 15 - element.upperLeft.y);
    }

    public void paint(UIElement element, Map resourceMap, GC g, int style) {
        Color elementBlue = element.getColor(resourceMap, "COLOR_ELEMENT_BLUE", 201, 229, 255);
        Color blue = element.getColor(resourceMap, "COLOR_BLUE", 0, 0, 255);
        Color black = element.getColor(resourceMap, "COLOR_BLACK", 0, 0, 0);
        Color foreground = g.getForeground();
        Color background = g.getBackground();
        g.setBackground(elementBlue);
        g.fillOval(element.upperLeft.x, element.upperLeft.y, element.lowerRight.x - element.upperLeft.x, element.lowerRight.y - element.upperLeft.y);
        if ((style & 4) == 0 && element.isSelected()) {
            g.setForeground(blue);
        } else {
            g.setForeground(black);
        }
        g.drawOval(element.upperLeft.x, element.upperLeft.y, element.lowerRight.x - element.upperLeft.x, element.lowerRight.y - element.upperLeft.y);
        if ((style & 2) == 0) {
            Point np = g.stringExtent(element.getName());
            g.drawString(element.getName(), element.getX() - np.x / 2, element.getY() - np.y / 2, true);
        }
        if ((style & 0x10) == 0) {
            if (element.getElement().hasError()) {
                g.drawImage(UIElement.errorIcon, element.lowerRight.x - UIElement.errorIcon.getImageData().width, element.upperLeft.y);
            } else if (element.getElement().hasWarning()) {
                g.drawImage(UIElement.warningIcon, element.lowerRight.x - UIElement.warningIcon.getImageData().width, element.upperLeft.y);
            } else if (element.getElement().hasTodo()) {
                g.drawImage(UIElement.todoIcon, element.lowerRight.x - UIElement.todoIcon.getImageData().width, element.upperLeft.y);
            }
        }
        g.setForeground(foreground);
        g.setBackground(background);
    }

    public void paintShadows(UIElement element, Map resourceMap, GC g) {
        Color shadowBlue = element.getColor(resourceMap, "COLOR_SHADOW_BLUE", 201, 229, 255);
        Color background = g.getBackground();
        g.setBackground(shadowBlue);
        g.fillOval(element.upperLeft.x + 5, element.upperLeft.y + 5, element.lowerRight.x - element.upperLeft.x, element.lowerRight.y - element.upperLeft.y);
        g.setBackground(background);
    }
}

