/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editors;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IAudioFile;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.core.project.IMediaFile;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.ISupportedLanguage;
import org.eclipse.vtp.desktop.ui.app.editors.UIPersonaIndex;
import org.eclipse.vtp.framework.media.binding.MediaBinding;
import org.eclipse.vtp.framework.media.util.BrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.DefaultBindingIndex;
import org.eclipse.vtp.framework.media.util.DefaultBrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.PersonaIndex;
import org.eclipse.vtp.framework.media.xml.MediaXML;

public class UIDefaultBindingIndex
extends DefaultBindingIndex {
    private final IMediaFilesFolder files;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UIDefaultBindingIndex(IBrand brand, MediaBinding binding) throws IOException, CoreException {
        Object var6_6;
        DefaultBrandLibraryIndex b = new DefaultBrandLibraryIndex();
        LinkedList<UIPersonaIndex> personas = new LinkedList<UIPersonaIndex>();
        Iterator i = ((IApplicationProject)brand.getBrandSet().getProject()).getSupportedLanguages().iterator();
        while (i.hasNext()) {
            ISupportedLanguage lang = (ISupportedLanguage)i.next();
            IPersonaProject supportingPersona = lang.getSupportingPersona();
            if (supportingPersona == null) continue;
            personas.add(new UIPersonaIndex(supportingPersona));
        }
        b.setPersonas(personas.toArray(new PersonaIndex[personas.size()]));
        InputStream input = null;
        try {
            input = brand.getPromptSet().read();
            b.setLibrary(MediaXML.loadLibrary((Source)new StreamSource(input)));
            var6_6 = null;
        }
        catch (Throwable throwable) {
            var6_6 = null;
            try {
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (input != null) {
            input.close();
        }
        this.setBrand((BrandLibraryIndex)b);
        this.files = brand.getMediaFilesFolder();
        this.setBinding(binding);
    }

    public String getAlternateText(String arg0) {
        IMediaFilesFolder container = this.files;
        IMediaFile file = null;
        StringTokenizer st = new StringTokenizer(arg0, "/\\");
        while (st.hasMoreElements()) {
            String nextToken = st.nextToken();
            if (st.hasMoreTokens()) {
                container = container.getMediaFolder(nextToken);
                continue;
            }
            file = container.getMediaFile(nextToken);
        }
        if (file instanceof IAudioFile) {
            return ((IAudioFile)file).getAlternateText();
        }
        return "";
    }
}

