/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;

public class GRXMLEditorPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String[][] ENTRIES = new String[][]{{"grxmleditor.colors.comment", "Comments"}, {"grxmleditor.colors.elements", "Elements"}, {"grxmleditor.colors.attributes", "Attributes"}};
    List colorList = null;
    Button colorButton = null;
    ColorSelector colorEditor = null;
    Map values = new HashMap();

    public GRXMLEditorPreferences() {
        super(1);
        this.setPreferenceStore(ApplicationUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("GRXML Editor color options:");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        int i = 0;
        while (i < ENTRIES.length) {
            if (!this.getPreferenceStore().contains(ENTRIES[i][0])) {
                RGB rgb = parent.getDisplay().getSystemColor(26).getRGB();
                this.values.put(ENTRIES[i][0], rgb);
                PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)ENTRIES[i][0], (RGB)rgb);
            } else {
                this.values.put(ENTRIES[i][0], PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)ENTRIES[i][0]));
            }
            ++i;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1296);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        this.colorList = new List(composite, 2564);
        gd = new GridData(1810);
        gd.heightHint = this.colorList.getItemHeight() * 8;
        this.colorList.setLayoutData((Object)gd);
        int i2 = 0;
        while (i2 < ENTRIES.length) {
            this.colorList.add(ENTRIES[i2][1]);
            ++i2;
        }
        Composite stylesComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        Label l = new Label(stylesComposite, 16384);
        l.setText("&Color:");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.colorButton = new Button(stylesComposite, 32);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.colorButton.setLayoutData((Object)gd);
        this.colorButton.setVisible(false);
        this.colorEditor = new ColorSelector(stylesComposite);
        Button selectorButton = this.colorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        selectorButton.setLayoutData((Object)gd);
        this.colorList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = GRXMLEditorPreferences.this.colorList.getSelectionIndex();
                if (index < 0) {
                    GRXMLEditorPreferences.this.colorButton.setEnabled(false);
                } else {
                    GRXMLEditorPreferences.this.colorButton.setEnabled(true);
                    RGB rgb = (RGB)GRXMLEditorPreferences.this.values.get(ENTRIES[index][0]);
                    GRXMLEditorPreferences.this.colorEditor.setColorValue(rgb);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.colorButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GRXMLEditorPreferences.this.colorEditor.getButton().setEnabled(!GRXMLEditorPreferences.this.colorButton.getSelection());
                int i = GRXMLEditorPreferences.this.colorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.colorEditor.getButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = GRXMLEditorPreferences.this.colorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                GRXMLEditorPreferences.this.values.put(ENTRIES[i][0], GRXMLEditorPreferences.this.colorEditor.getColorValue());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.initialize();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public boolean performOk() {
        int i = 0;
        while (i < ENTRIES.length) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)ENTRIES[i][0]);
            if (!rgb.equals(this.values.get(ENTRIES[i][0]))) {
                PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)ENTRIES[i][0], (RGB)((RGB)this.values.get(ENTRIES[i][0])));
            }
            ++i;
        }
        return super.performOk();
    }

    public void createFieldEditors() {
    }
}

