/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalLanguagePack;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.ISupportedLanguage;
import org.eclipse.vtp.desktop.core.project.internals.SupportedLanguage;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;

public class ApplicationProjectBuildPropertyPage
extends PropertyPage {
    TableViewer sharedLibraryViewer;
    List sharedLibraryRecords = new ArrayList();
    TreeViewer personaViewer;
    LanguageStructure ls = new LanguageStructure();
    ComboBoxCellEditor personaEditor;
    List personaProjects;
    List currentList = new ArrayList();

    private void addFirstSection(Composite composite) {
        IApplicationProject applicationProject = (IApplicationProject)this.getElement();
        this.personaProjects = new ArrayList();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].hasNature("org.eclipse.vtp.desktop.core.VoicePersonaNature")) {
                    IPersonaProject pp = DesktopCorePlugin.convertToPersona((IProject)projects[i]);
                    this.personaProjects.add(pp);
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            ++i;
        }
        ILocalDomain localDomain = DesktopCorePlugin.getDefault().getLocalDomain();
        List vendors = localDomain.getVendors();
        Iterator vendorIterator = vendors.iterator();
        while (vendorIterator.hasNext()) {
            ILocalVendor localVendor = (ILocalVendor)vendorIterator.next();
            List languagePacks = localVendor.getLanguagePacks();
            Iterator languagePackIterator = languagePacks.iterator();
            while (languagePackIterator.hasNext()) {
                ILocalLanguagePack localLanguagePack = (ILocalLanguagePack)languagePackIterator.next();
                this.ls.addLanguageSupport(localLanguagePack.getLanguageCode(), null);
            }
        }
        List supportedLanguages = applicationProject.getSupportedLanguages();
        Iterator languageIterator = supportedLanguages.iterator();
        while (languageIterator.hasNext()) {
            ISupportedLanguage supportedLanguage = (ISupportedLanguage)languageIterator.next();
            this.ls.addLanguageSupport(supportedLanguage);
        }
        TabFolder tabs = new TabFolder(composite, 0);
        tabs.setLayoutData((Object)new GridData(1808));
        tabs.setLayout((Layout)new GridLayout());
        TabItem personasItem = new TabItem(tabs, 0);
        personasItem.setText("Language Support");
        Composite personaComp = new Composite((Composite)tabs, 0);
        personaComp.setLayout((Layout)new GridLayout(2, false));
        Label personaTableLabel = new Label(personaComp, 0);
        personaTableLabel.setText("Currently supported languages");
        Composite blankComp = new Composite(personaComp, 0);
        GridData bgd = new GridData();
        bgd.heightHint = 1;
        bgd.widthHint = 1;
        bgd.grabExcessHorizontalSpace = false;
        bgd.grabExcessVerticalSpace = false;
        blankComp.setLayoutData((Object)bgd);
        Tree personaTree = new Tree(personaComp, 67588);
        personaTree.setHeaderVisible(true);
        personaTree.setLinesVisible(true);
        personaTree.setLayoutData((Object)new GridData(1808));
        TreeColumn languageColumn = new TreeColumn(personaTree, 0);
        languageColumn.setText("Language");
        languageColumn.setWidth(200);
        TreeColumn personaColumn = new TreeColumn(personaTree, 0);
        personaColumn.setText("Persona");
        personaColumn.setWidth(150);
        this.personaEditor = new ComboBoxCellEditor((Composite)personaTree, new String[]{"1", "2", "3"}, 12);
        this.personaViewer = new TreeViewer(personaTree);
        this.personaViewer.setColumnProperties(new String[]{"Language", "Persona"});
        this.personaViewer.setContentProvider((IContentProvider)new PersonaContentProvider());
        this.personaViewer.setLabelProvider((IBaseLabelProvider)new PersonaLabelProvider());
        this.personaViewer.setCellModifier((ICellModifier)new PersonaCellModifier());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.personaEditor;
        this.personaViewer.setCellEditors(cellEditorArray);
        this.personaViewer.setInput((Object)this);
        personasItem.setControl((Control)personaComp);
        Composite buttonComp = new Composite(personaComp, 0);
        GridLayout gl = new GridLayout();
        buttonComp.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        buttonComp.setLayoutData((Object)gd);
        final Button addButton = new Button(buttonComp, 8);
        addButton.setText("Add Variant");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setEnabled(false);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LanguageStructure.Entry entry = (LanguageStructure.Entry)((IStructuredSelection)ApplicationProjectBuildPropertyPage.this.personaViewer.getSelection()).getFirstElement();
                if (!entry.getSupportedLanguage().getLocale().getVariant().equals("")) {
                    entry = entry.getParent();
                }
                List children = entry.getChildren();
                InputDialog variantDialog = new InputDialog(addButton.getShell(), "Add New Variant", "Please enter the name of the new variant", "", new IInputValidator(this, children){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ List val$children;
                    {
                        this.this$1 = var1_1;
                        this.val$children = list;
                    }

                    public String isValid(String newText) {
                        Iterator<E> iterator = this.val$children.iterator();
                        while (iterator.hasNext()) {
                            LanguageStructure.Entry le = (LanguageStructure.Entry)iterator.next();
                            if (!le.getSupportedLanguage().getLocale().getVariant().equalsIgnoreCase(newText)) continue;
                            return "That language variant already exists";
                        }
                        return null;
                    }
                });
                int result = variantDialog.open();
                if (result == 0) {
                    ApplicationProjectBuildPropertyPage.this.ls.addLanguageSupport(new Locale(entry.getSupportedLanguage().getLocale().getLanguage(), entry.getSupportedLanguage().getLocale().getCountry(), variantDialog.getValue()), null);
                    ApplicationProjectBuildPropertyPage.this.personaViewer.refresh((Object)entry, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button removeButton = new Button(buttonComp, 8);
        removeButton.setText("Remove Variant");
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ApplicationProjectBuildPropertyPage.this.personaViewer.getSelection();
                LanguageStructure.Entry entry = (LanguageStructure.Entry)selection.getFirstElement();
                entry.getParent().removeChild(entry.getSupportedLanguage().getLocale());
                ApplicationProjectBuildPropertyPage.this.personaViewer.refresh((Object)entry.getParent());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.personaViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                LanguageStructure.Entry entry = (LanguageStructure.Entry)selection.getFirstElement();
                if (entry != null) {
                    addButton.setEnabled(entry.getParent() != null);
                    removeButton.setEnabled(entry.getParent() == null ? false : entry.getParent().getParent() != null);
                } else {
                    addButton.setEnabled(false);
                    removeButton.setEnabled(false);
                }
            }
        });
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        return composite;
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        IApplicationProject applicationProject = (IApplicationProject)this.getElement();
        ISupportedLanguage[] langs = this.ls.toArray();
        ArrayList<ISupportedLanguage> l = new ArrayList<ISupportedLanguage>(langs.length);
        int i = 0;
        while (i < langs.length) {
            l.add(langs[i]);
            ++i;
        }
        applicationProject.setSupportedLanguages(l);
        return true;
    }

    public class LanguageStructure {
        Map languageMap = new HashMap();

        public void addLanguageSupport(ISupportedLanguage supportedLanguage) {
            Entry lang;
            Locale locale = supportedLanguage.getLocale();
            Locale languageLocale = new Locale(locale.getLanguage());
            Object obj = this.languageMap.get(languageLocale);
            if (obj == null) {
                Entry entry = null;
                entry = locale.equals(languageLocale) ? new Entry(supportedLanguage) : new Entry((ISupportedLanguage)new SupportedLanguage(languageLocale, supportedLanguage.getSupportingPersona()));
                obj = entry;
                this.languageMap.put(languageLocale, entry);
            }
            if ((lang = (Entry)obj).getSupportedLanguage().getSupportingPersona() == null) {
                lang.supportedLanguage = new SupportedLanguage(languageLocale, supportedLanguage.getSupportingPersona());
            }
            if (!languageLocale.equals(locale)) {
                Entry country;
                Locale countryLocale = new Locale(locale.getLanguage(), locale.getCountry());
                obj = lang.getChild(countryLocale);
                if (obj == null) {
                    Entry entry = null;
                    entry = countryLocale.equals(locale) ? new Entry(supportedLanguage) : new Entry((ISupportedLanguage)new SupportedLanguage(countryLocale, supportedLanguage.getSupportingPersona()));
                    obj = entry;
                    lang.putChild(entry);
                }
                if ((country = (Entry)obj).getSupportedLanguage().getSupportingPersona() == null) {
                    country.supportedLanguage = new SupportedLanguage(countryLocale, supportedLanguage.getSupportingPersona());
                }
                if (!countryLocale.equals(locale)) {
                    obj = country.getChild(locale);
                    if (obj == null) {
                        obj = new Entry(supportedLanguage);
                        country.putChild((Entry)obj);
                    }
                    Entry variant = (Entry)obj;
                    variant.supportedLanguage = supportedLanguage;
                } else {
                    country.supportedLanguage = supportedLanguage;
                }
            } else {
                lang.supportedLanguage = supportedLanguage;
            }
        }

        public void addLanguageSupport(String localeCode, IPersonaProject persona) {
            String[] parts = localeCode.split("-");
            String languageCode = "";
            String countryCode = "";
            String variantCode = "";
            if (parts.length > 2) {
                variantCode = parts[2];
            }
            if (parts.length > 1) {
                countryCode = parts[1];
            }
            languageCode = parts[0];
            this.addLanguageSupport((ISupportedLanguage)new SupportedLanguage(new Locale(languageCode, countryCode, variantCode), persona));
        }

        public void addLanguageSupport(Locale locale, IPersonaProject persona) {
            this.addLanguageSupport((ISupportedLanguage)new SupportedLanguage(locale, persona));
        }

        public List getSupportedLanguages() {
            ArrayList<Entry> ret = new ArrayList<Entry>();
            Collection c = this.languageMap.values();
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                Entry child = (Entry)iterator.next();
                ret.add(child);
            }
            return ret;
        }

        public ISupportedLanguage[] toArray() {
            ArrayList<ISupportedLanguage> ret = new ArrayList<ISupportedLanguage>();
            Collection c = this.languageMap.values();
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                Entry child = (Entry)iterator.next();
                ret.add(child.getSupportedLanguage());
                ret.addAll(child.dumpLanguages());
            }
            return ret.toArray(new ISupportedLanguage[ret.size()]);
        }

        public class Entry {
            Entry parentEntry;
            ISupportedLanguage supportedLanguage;
            Map childMap = new HashMap();

            public Entry(ISupportedLanguage supportedLanguage) {
                this.supportedLanguage = supportedLanguage;
            }

            public ISupportedLanguage getSupportedLanguage() {
                return this.supportedLanguage;
            }

            public void addChild(ISupportedLanguage child) {
                Locale childLocale = child.getLocale();
                Object obj = this.childMap.get(childLocale);
                if (obj == null) {
                    this.childMap.put(childLocale, new Entry(child));
                }
                ((Entry)obj).supportedLanguage = child;
                ((Entry)obj).parentEntry = this;
            }

            public Entry getParent() {
                return this.parentEntry;
            }

            public void putChild(Entry child) {
                this.childMap.put(child.getSupportedLanguage().getLocale(), child);
                child.parentEntry = this;
            }

            public Entry getChild(Locale childLocale) {
                return (Entry)this.childMap.get(childLocale);
            }

            public void removeChild(Locale childLocale) {
                this.childMap.remove(childLocale);
            }

            public List getChildren() {
                ArrayList<Entry> ret = new ArrayList<Entry>();
                Collection children = this.childMap.values();
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    Entry child = (Entry)iterator.next();
                    ret.add(child);
                }
                return ret;
            }

            public List dumpLanguages() {
                ArrayList<ISupportedLanguage> ret = new ArrayList<ISupportedLanguage>();
                Collection children = this.childMap.values();
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    Entry child = (Entry)iterator.next();
                    ret.add(child.getSupportedLanguage());
                    ret.addAll(child.dumpLanguages());
                }
                return ret;
            }
        }
    }

    public class PersonaCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return property.equals("Persona");
        }

        public Object getValue(Object element, String property) {
            LanguageStructure.Entry entry = (LanguageStructure.Entry)element;
            if (property.equals("Persona")) {
                ApplicationProjectBuildPropertyPage.this.currentList.clear();
                Locale locale = entry.getSupportedLanguage().getLocale();
                int selected = 0;
                int pos = 0;
                Iterator iterator = ApplicationProjectBuildPropertyPage.this.personaProjects.iterator();
                while (iterator.hasNext()) {
                    IPersonaProject pp = (IPersonaProject)iterator.next();
                    String languageCode = "";
                    try {
                        languageCode = pp.getLanguageCode();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (!locale.getVariant().equals("")) {
                        if (languageCode.equals(String.valueOf(locale.getLanguage()) + "-" + locale.getCountry())) {
                            ApplicationProjectBuildPropertyPage.this.currentList.add(pp);
                            if (pp.equals(entry.getSupportedLanguage().getSupportingPersona())) {
                                selected = pos;
                            }
                        }
                    } else if (!locale.getCountry().equals("")) {
                        if (languageCode.equals(String.valueOf(locale.getLanguage()) + "-" + locale.getCountry())) {
                            ApplicationProjectBuildPropertyPage.this.currentList.add(pp);
                            if (pp.equals(entry.getSupportedLanguage().getSupportingPersona())) {
                                selected = pos;
                            }
                        }
                    } else if (languageCode.startsWith(locale.getLanguage())) {
                        ApplicationProjectBuildPropertyPage.this.currentList.add(pp);
                        if (pp.equals(entry.getSupportedLanguage().getSupportingPersona())) {
                            selected = pos;
                        }
                    }
                    ++pos;
                }
                if (!locale.getVariant().equals("")) {
                    ApplicationProjectBuildPropertyPage.this.currentList.add(0, null);
                } else if (!locale.getCountry().equals("")) {
                    ApplicationProjectBuildPropertyPage.this.currentList.add(0, null);
                } else {
                    boolean foundOne = false;
                    List langs = entry.dumpLanguages();
                    int i = 0;
                    while (i < langs.size()) {
                        if (((ISupportedLanguage)langs.get(i)).getSupportingPersona() != null) {
                            foundOne = true;
                            break;
                        }
                        ++i;
                    }
                    if (!foundOne) {
                        ApplicationProjectBuildPropertyPage.this.currentList.add(0, null);
                    }
                }
                String[] items = new String[ApplicationProjectBuildPropertyPage.this.currentList.size()];
                int i = 0;
                while (i < items.length) {
                    Object obj = ApplicationProjectBuildPropertyPage.this.currentList.get(i);
                    if (obj == null) {
                        items[i] = !locale.getVariant().equals("") ? (entry.getParent().getSupportedLanguage().getSupportingPersona() == null && entry.getParent().getParent().getSupportedLanguage().getSupportingPersona() == null ? "Unsupported" : "Inherit from above") : (!locale.getCountry().equals("") ? (entry.getParent().getSupportedLanguage().getSupportingPersona() == null ? "Unsupported" : "Inherit from above") : "Unsupported");
                    } else {
                        IPersonaProject pp = (IPersonaProject)ApplicationProjectBuildPropertyPage.this.currentList.get(i);
                        try {
                            items[i] = pp.getPersonaName();
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            items[i] = "Error";
                        }
                    }
                    ++i;
                }
                ApplicationProjectBuildPropertyPage.this.personaEditor.setItems(items);
                return new Integer(selected);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            LanguageStructure.Entry entry = (LanguageStructure.Entry)((TreeItem)element).getData();
            if (property.equals("Persona")) {
                Integer index = (Integer)value;
                ApplicationProjectBuildPropertyPage.this.ls.addLanguageSupport(entry.getSupportedLanguage().getLocale(), (IPersonaProject)ApplicationProjectBuildPropertyPage.this.currentList.get(index));
                ApplicationProjectBuildPropertyPage.this.personaViewer.refresh((Object)entry, true);
                if (entry.getParent() != null) {
                    ApplicationProjectBuildPropertyPage.this.personaViewer.refresh((Object)entry.getParent(), true);
                    if (entry.getParent().getParent() != null) {
                        ApplicationProjectBuildPropertyPage.this.personaViewer.refresh((Object)entry.getParent().getParent(), true);
                    }
                }
                List sl = ApplicationProjectBuildPropertyPage.this.ls.getSupportedLanguages();
                boolean finished = true;
                int i = 0;
                while (i < sl.size()) {
                    entry = (LanguageStructure.Entry)sl.get(i);
                    ISupportedLanguage isl = entry.getSupportedLanguage();
                    finished &= isl.getSupportingPersona() != null;
                    ++i;
                }
                ApplicationProjectBuildPropertyPage.this.setValid(finished);
            }
        }
    }

    public class PersonaContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return ApplicationProjectBuildPropertyPage.this.ls.getSupportedLanguages().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return ((LanguageStructure.Entry)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((LanguageStructure.Entry)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((LanguageStructure.Entry)element).getChildren().size() > 0;
        }
    }

    public class PersonaLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            LanguageStructure.Entry entry = (LanguageStructure.Entry)element;
            if (columnIndex == 0) {
                return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_FOLDER_OPEN");
            }
            if (columnIndex == 1 && entry.getSupportedLanguage().getSupportingPersona() != null) {
                return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_PERSONA");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            LanguageStructure.Entry entry = (LanguageStructure.Entry)element;
            Locale locale = entry.getSupportedLanguage().getLocale();
            int level = 0;
            if (!locale.getCountry().equals("")) {
                ++level;
            }
            if (!locale.getVariant().equals("")) {
                ++level;
            }
            if (columnIndex == 0) {
                if (level == 0) {
                    return locale.getDisplayLanguage();
                }
                if (level == 1) {
                    return locale.getDisplayCountry();
                }
                return locale.getDisplayVariant();
            }
            if (columnIndex == 1) {
                block14: {
                    block13: {
                        if (entry.getSupportedLanguage().getSupportingPersona() != null) {
                            return entry.getSupportedLanguage().getSupportingPersona().getPersonaName();
                        }
                        if (level != 0) break block13;
                        return "Unsupported";
                    }
                    if (level != 1) break block14;
                    if (entry.getParent().getSupportedLanguage().getSupportingPersona() == null) {
                        return "Unsupported";
                    }
                    return "Inherit from above";
                }
                try {
                    if (entry.getParent().getSupportedLanguage().getSupportingPersona() == null && entry.getParent().getParent().getSupportedLanguage().getSupportingPersona() == null) {
                        return "Unsupported";
                    }
                    return "Inherit from above";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return "Unknown";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

