/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModel;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeExitElement;

public class CreateWormholeEntryWizard
extends Wizard {
    private WormholeExitPage page = null;
    private ApplicationModel model = null;
    private WormholeExitElement wormhole;

    public CreateWormholeEntryWizard(ApplicationModel model) {
        this.model = model;
        this.page = new WormholeExitPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.wormhole = this.page.getWormhole();
        return true;
    }

    public WormholeExitElement getWormhole() {
        return this.wormhole;
    }

    private class WormholeExitPage
    extends WizardPage {
        Combo exitCombo;

        public WormholeExitPage() {
            super("CreateApplicationPage", "Create Wormhole Entry Point", null);
            this.exitCombo = null;
        }

        public void createControl(Composite parent) {
            this.setControl((Control)parent);
            List wormholes = CreateWormholeEntryWizard.this.model.listWormholes();
            Label hostLabel = new Label(parent, 0);
            if (wormholes.size() > 0) {
                hostLabel.setText("Select the exit point:");
            } else {
                hostLabel.setText("There are no current exit points.  Press finish to continue.");
            }
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            parent.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 10);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 10 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            if (wormholes.size() > 0) {
                this.exitCombo = new Combo(parent, 12);
                Iterator iterator = wormholes.iterator();
                while (iterator.hasNext()) {
                    this.exitCombo.add(((WormholeExitElement)iterator.next()).getName());
                }
                this.exitCombo.select(0);
                FormData hostFieldFormData = new FormData();
                hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
                hostFieldFormData.top = new FormAttachment(0, 10);
                hostFieldFormData.right = new FormAttachment(100, -10);
                this.exitCombo.setLayoutData((Object)hostFieldFormData);
            }
        }

        public WormholeExitElement getWormhole() {
            if (this.exitCombo == null) {
                return null;
            }
            return (WormholeExitElement)CreateWormholeEntryWizard.this.model.listWormholes().get(this.exitCombo.getSelectionIndex());
        }
    }
}

