/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroup;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.ISupportedLanguage;
import org.eclipse.vtp.desktop.core.project.IWebService;
import org.eclipse.vtp.desktop.core.project.IWebServicePort;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExportWebappWizard
extends Wizard
implements IExportWizard {
    private static final String PREFIX = "org.eclipse.vtp.framework.";
    private static final String API_BUNDLE = "org.eclipse.vtp.framework.api";
    private static final String INFOSERV_API_BUNDLE = "org.eclipse.vtp.framework.infoserv.api";
    private static final String INFOSERV_CORE_BUNDLE = "org.eclipse.vtp.framework.infoserv.core";
    private static final String INFOSERV_SPI_BUNDLE = "org.eclipse.vtp.framework.infoserv.spi";
    private static final String KERNEL_BUNDLE = "org.eclipse.vtp.framework.kernel";
    private static final String MEDIA_BUNDLE = "org.eclipse.vtp.framework.media";
    private static final String GENESYS_PLATFORM_BUNDLE = "org.eclipse.vtp.framework.platforms.genesys";
    private static final String WIDGETS_BUNDLE = "org.eclipse.vtp.framework.widgets";
    private static final String UTIL_BUNDLE = "org.eclipse.vtp.framework.util";
    private static final Set FRAMEWORK_BUNDLES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.eclipse.vtp.framework.api", "org.eclipse.vtp.framework.infoserv.api", "org.eclipse.vtp.framework.infoserv.core", "org.eclipse.vtp.framework.infoserv.spi", "org.eclipse.vtp.framework.kernel", "org.eclipse.vtp.framework.media", "org.eclipse.vtp.framework.platforms.genesys", "org.eclipse.vtp.framework.widgets", "org.eclipse.vtp.framework.util", "org.apache.commons.io", "org.apache.commons.fileupload")));
    private static final String DB_PROP_TYPE = "type";
    private static final String DB_TYPE_JNDI = "jndi";
    private static final String DB_TYPE_JDBC = "jdbc";
    private static final String DB_PROP_JNDI_URI = "jndi.uri";
    private static final String DB_PROP_JNDI_USR = "jndi.usr";
    private static final String DB_PROP_JNDI_PWD = "jndi.pwd";
    private static final String DB_PROP_JDBC_DVR = "jdbc.dvr";
    private static final String DB_PROP_JDBC_URL = "jdbc.url";
    private static final String DB_PROP_JDBC_USR = "jdbc.usr";
    private static final String DB_PROP_JDBC_PWD = "jdbc.pwd";
    private static final String WS_PROP_ENDPOINT = "endpoint";
    private URL installURL = null;
    private IApplicationProject applicationProject = null;
    private Map personaProjects = new TreeMap();
    private Map frameworkBundles = new TreeMap();
    private Map axisJars = new TreeMap();
    private Map languageBundles = new TreeMap();
    private Map moduleBundles = new TreeMap();
    private Map dependencies = new TreeMap();
    private Map databases = new TreeMap();
    private Map webServices = new TreeMap();
    private File war = null;

    public ExportWebappWizard() {
        this.setNeedsProgressMonitor(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeWizard(Object selected) throws CoreException {
        IFolder dbFolder;
        try {
            this.installURL = new URL(ApplicationUIPlugin.getDefault().getInstallLocation());
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
        this.applicationProject = selected instanceof IApplicationProject ? (IApplicationProject)selected : DesktopCorePlugin.convertToApplication((IProject)((IResource)selected).getProject());
        Iterator i = this.applicationProject.getSupportedLanguages().iterator();
        while (i.hasNext()) {
            IPersonaProject persona = ((ISupportedLanguage)i.next()).getSupportingPersona();
            if (persona == null) continue;
            this.personaProjects.put(persona.getLanguagePackId(), persona);
        }
        String frameworkVersion = this.applicationProject.getApplicationFrameworkVersion();
        Bundle[] bundles = ApplicationUIPlugin.getDefault().getBundles();
        int i2 = 0;
        while (i2 < bundles.length) {
            String symbolicName = bundles[i2].getSymbolicName();
            if (FRAMEWORK_BUNDLES.contains(symbolicName) && bundles[i2].getHeaders().get("Bundle-Version").toString().startsWith(frameworkVersion)) {
                this.frameworkBundles.put(symbolicName, new EmbeddedFrameworkJar(bundles[i2]));
            } else if (this.personaProjects.containsKey(symbolicName) && bundles[i2].getHeaders().get("Bundle-Version").toString().startsWith(frameworkVersion)) {
                this.languageBundles.put(symbolicName, new EmbeddedLanguagePackJar(bundles[i2], ((IPersonaProject)this.personaProjects.get(symbolicName)).getLanguageCode()));
            }
            ++i2;
        }
        Map axisRegistry = DesktopCorePlugin.getDefault().getAxisJars();
        Iterator i3 = axisRegistry.keySet().iterator();
        while (i3.hasNext()) {
            String jarName = (String)i3.next();
            this.axisJars.put(jarName, new EmbeddedAxisJar((File)axisRegistry.get(jarName)));
        }
        Document doc = null;
        InputStream in = null;
        try {
            try {
                in = this.applicationProject.getApplicationDesign().read();
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
            catch (ParserConfigurationException e) {
                throw new CoreException((IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
            catch (SAXException e) {
                throw new CoreException((IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
            Object var8_17 = null;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (in != null) {
            in.close();
        }
        ILocalDomain domain = DesktopCorePlugin.getDefault().getLocalDomain();
        NodeList list = doc.getDocumentElement().getElementsByTagName("module");
        int i4 = 0;
        while (i4 < list.getLength()) {
            Bundle bundle;
            ILocalModuleGroupVersion version;
            ILocalModuleGroup group;
            Element element = (Element)list.item(i4);
            ILocalVendor vendor = domain.getVendorByName(element.getAttribute("vendor"));
            if (vendor != null && (group = vendor.getModuleGroupByName(element.getAttribute("module-group"))) != null && (version = group.getVersionByNumber(element.getAttribute("version-number"))) != null && (bundle = version.getBundle()) != null) {
                this.moduleBundles.put(bundle.getSymbolicName(), new EmbeddedModuleJar(bundle, vendor.getName(), group.getName(), version.getVersionNumber()));
            }
            ++i4;
        }
        IFolder depFolder = this.applicationProject.getUnderlyingProject().getFolder("Dependencies");
        if (depFolder.exists()) {
            IResource[] children = depFolder.members();
            int i5 = 0;
            while (i5 < children.length) {
                if (children[i5].getType() == 1 && !children[i5].getName().startsWith(".")) {
                    this.dependencies.put(children[i5].getName(), new EmbeddedDependencyJar((IFile)children[i5]));
                }
                ++i5;
            }
        }
        if ((dbFolder = this.applicationProject.getUnderlyingProject().getFolder("Databases")).exists()) {
            IResource[] children = dbFolder.members();
            int i6 = 0;
            while (i6 < children.length) {
                if (children[i6].getType() == 2 && !children[i6].getName().startsWith(".")) {
                    Properties properties = new Properties();
                    properties.setProperty(DB_PROP_TYPE, DB_TYPE_JNDI);
                    properties.setProperty(DB_PROP_JNDI_URI, "jdbc/" + children[i6].getName());
                    properties.setProperty(DB_PROP_JNDI_USR, "");
                    properties.setProperty(DB_PROP_JNDI_PWD, "");
                    properties.setProperty(DB_PROP_JDBC_DVR, "");
                    properties.setProperty(DB_PROP_JDBC_URL, "");
                    properties.setProperty(DB_PROP_JDBC_USR, "");
                    properties.setProperty(DB_PROP_JDBC_PWD, "");
                    this.databases.put(children[i6].getName(), properties);
                }
                ++i6;
            }
        }
        Iterator i7 = this.applicationProject.getWebServiceSet().getWebServices().iterator();
        while (i7.hasNext()) {
            IWebService service = (IWebService)i7.next();
            Iterator j = service.getWebServicePorts().iterator();
            while (j.hasNext()) {
                IWebServicePort port = (IWebServicePort)j.next();
                Properties properties = new Properties();
                properties.setProperty(WS_PROP_ENDPOINT, "");
                this.webServices.put(String.valueOf(service.getName()) + "." + port.getName(), properties);
            }
        }
    }

    private boolean writeWAR(final IProgressMonitor monitor, final ZipOutputStream out) throws CoreException {
        final int[] fileCount = new int[1];
        IResourceVisitor countVisitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 4) {
                    return true;
                }
                if (resource.getType() == 2) {
                    return !resource.getParent().equals((Object)ExportWebappWizard.this.applicationProject.getUnderlyingProject()) || !resource.getName().equals("Dependencies") && !resource.getName().equals("Web Services");
                }
                fileCount[0] = fileCount[0] + 1;
                return false;
            }
        };
        this.applicationProject.getUnderlyingProject().accept(countVisitor);
        Iterator i = this.personaProjects.values().iterator();
        while (i.hasNext()) {
            ((IPersonaProject)i.next()).getUnderlyingProject().accept(countVisitor);
        }
        LinkedList jars = new LinkedList();
        jars.addAll(this.frameworkBundles.values());
        if (!this.webServices.isEmpty()) {
            jars.addAll(this.axisJars.values());
        }
        jars.addAll(this.languageBundles.values());
        jars.addAll(this.moduleBundles.values());
        jars.addAll(this.dependencies.values());
        monitor.beginTask("Creating WAR", fileCount[0] + jars.size() + this.applicationProject.getWebServiceSet().getWebServices().size() + 1);
        if (monitor.isCanceled()) {
            return false;
        }
        try {
            Properties dbProps;
            String dbName;
            out.putNextEntry(new ZipEntry("WEB-INF/web.xml"));
            XMLWriter writer = new XMLWriter(out);
            writer.startElement("web-app");
            Iterator i2 = this.databases.keySet().iterator();
            while (i2.hasNext()) {
                dbName = (String)i2.next();
                dbProps = (Properties)this.databases.get(dbName);
                if (DB_TYPE_JNDI.equals(dbProps.getProperty(DB_PROP_TYPE))) {
                    writer.startElement("context-param");
                    writer.writeElement("param-name", "db." + dbName + ".type");
                    writer.writeElement("param-value", DB_TYPE_JNDI);
                    writer.endElement("context-param");
                    writer.startElement("context-param");
                    writer.writeElement("param-name", "db." + dbName + ".uri");
                    writer.writeElement("param-value", dbProps.getProperty(DB_PROP_JNDI_URI));
                    writer.endElement("context-param");
                    writer.startElement("context-param");
                    writer.writeElement("param-name", "db." + dbName + ".usr");
                    writer.writeElement("param-value", dbProps.getProperty(DB_PROP_JNDI_USR));
                    writer.endElement("context-param");
                    writer.startElement("context-param");
                    writer.writeElement("param-name", "db." + dbName + ".pwd");
                    writer.writeElement("param-value", dbProps.getProperty(DB_PROP_JNDI_PWD));
                    writer.endElement("context-param");
                    continue;
                }
                writer.startElement("context-param");
                writer.writeElement("param-name", "db." + dbName + ".type");
                writer.writeElement("param-value", DB_TYPE_JDBC);
                writer.endElement("context-param");
                writer.startElement("context-param");
                writer.writeElement("param-name", "db." + dbName + ".dvr");
                writer.writeElement("param-value", dbProps.getProperty(DB_PROP_JDBC_DVR));
                writer.endElement("context-param");
                writer.startElement("context-param");
                writer.writeElement("param-name", "db." + dbName + ".url");
                writer.writeElement("param-value", dbProps.getProperty(DB_PROP_JDBC_URL));
                writer.endElement("context-param");
                writer.startElement("context-param");
                writer.writeElement("param-name", "db." + dbName + ".usr");
                writer.writeElement("param-value", dbProps.getProperty(DB_PROP_JDBC_USR));
                writer.endElement("context-param");
                writer.startElement("context-param");
                writer.writeElement("param-name", "db." + dbName + ".pwd");
                writer.writeElement("param-value", dbProps.getProperty(DB_PROP_JDBC_PWD));
                writer.endElement("context-param");
            }
            i2 = this.webServices.keySet().iterator();
            while (i2.hasNext()) {
                String fqPortName = (String)i2.next();
                Properties wsProps = (Properties)this.webServices.get(fqPortName);
                writer.startElement("context-param");
                writer.writeElement("param-name", "ws." + fqPortName + ".endpoint");
                writer.writeElement("param-value", wsProps.getProperty(WS_PROP_ENDPOINT));
                writer.endElement("context-param");
            }
            writer.startElement("listener");
            writer.writeElement("listener-class", "org.eclipse.vtp.framework.kernel.http.HTTPLifecycleListner");
            writer.endElement("listener");
            writer.startElement("servlet");
            writer.writeElement("servlet-name", "httpConnector");
            writer.writeElement("servlet-class", "org.eclipse.vtp.framework.kernel.http.HTTPConnector");
            writer.endElement("servlet");
            writer.startElement("servlet");
            writer.writeElement("servlet-name", "httpResourceConnector");
            writer.writeElement("servlet-class", "org.eclipse.vtp.framework.kernel.http.HTTPResourceConnector");
            writer.endElement("servlet");
            writer.startElement("servlet-mapping");
            writer.writeElement("servlet-name", "httpConnector");
            writer.writeElement("url-pattern", "/openVXML/*");
            writer.endElement("servlet-mapping");
            writer.startElement("servlet-mapping");
            writer.writeElement("servlet-name", "httpResourceConnector");
            writer.writeElement("url-pattern", "/openVXML-files/*");
            writer.endElement("servlet-mapping");
            i2 = this.databases.keySet().iterator();
            while (i2.hasNext()) {
                dbName = (String)i2.next();
                dbProps = (Properties)this.databases.get(dbName);
                if (!DB_TYPE_JNDI.equals(dbProps.getProperty(DB_PROP_TYPE))) continue;
                writer.startElement("resource-ref");
                writer.writeElement("res-ref-name", dbProps.getProperty(DB_PROP_JNDI_URI));
                writer.writeElement("res-type", "javax.sql.DataSource");
                if (dbProps.getProperty(DB_PROP_JNDI_USR).length() == 0) {
                    writer.writeElement("res-auth", "Container");
                } else {
                    writer.writeElement("res-auth", "Application");
                }
                writer.endElement("resource-ref");
            }
            writer.endElement("web-app");
            out.closeEntry();
        }
        catch (IOException e) {
            new ErrorDialog(this.getShell(), "Error writing file: WEB-INF/web.xml", e.getMessage(), (IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
        }
        monitor.worked(1);
        final String[] targetPath = new String[]{"WEB-INF/openVXML/application/"};
        IResourceVisitor copyVisitor = new IResourceVisitor(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean visit(IResource resource) throws CoreException {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (resource.getType() == 4) {
                    return true;
                }
                if (resource.getType() == 2) {
                    if (!resource.getParent().equals((Object)ExportWebappWizard.this.applicationProject.getUnderlyingProject())) return true;
                    if (resource.getName().equals("Dependencies")) return false;
                    if (!resource.getName().equals("Web Services")) return true;
                    return false;
                }
                String path = String.valueOf(targetPath[0]) + resource.getProjectRelativePath();
                monitor.setTaskName("Adding file: " + path);
                InputStream in = null;
                try {
                    try {
                        in = ((IFile)resource).getContents();
                        out.putNextEntry(new ZipEntry(path));
                        byte[] buffer = new byte[10240];
                        int i = in.read(buffer);
                        while (true) {
                            if (i < 0) {
                                out.closeEntry();
                            }
                            out.write(buffer, 0, i);
                            i = in.read(buffer);
                        }
                    }
                    catch (IOException e) {
                        new ErrorDialog(ExportWebappWizard.this.getShell(), "Error writing file: " + path, e.getMessage(), (IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var6_9 = null;
                }
                try {}
                catch (IOException iOException) {}
                if (in != null) {
                    in.close();
                }
                monitor.worked(1);
                return false;
            }
        };
        if (monitor.isCanceled()) {
            return false;
        }
        this.applicationProject.getUnderlyingProject().accept(copyVisitor);
        if (monitor.isCanceled()) {
            return false;
        }
        Iterator<Object> i3 = this.personaProjects.values().iterator();
        while (i3.hasNext()) {
            if (monitor.isCanceled()) {
                return false;
            }
            IPersonaProject project = (IPersonaProject)i3.next();
            targetPath[0] = "WEB-INF/openVXML/personas/" + project.getPersonaId() + "/";
            project.getUnderlyingProject().accept(copyVisitor);
        }
        if (monitor.isCanceled()) {
            return false;
        }
        i3 = jars.iterator();
        while (i3.hasNext()) {
            EmbeddedJar jar = (EmbeddedJar)i3.next();
            if (monitor.isCanceled()) {
                return false;
            }
            monitor.setTaskName("Adding JAR: WEB-INF/lib/" + jar.getFileName());
            jar.embed(out);
            monitor.worked(1);
        }
        final String[] targetClassPath = new String[]{"WEB-INF/classes/"};
        IResourceVisitor copyClassesVisitor = new IResourceVisitor(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean visit(IResource resource) throws CoreException {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (resource.getType() == 2) {
                    return true;
                }
                String path = String.valueOf(targetClassPath[0]) + resource.getProjectRelativePath().removeFirstSegments(3);
                monitor.setTaskName("Adding class file: " + path);
                InputStream in = null;
                try {
                    try {
                        in = ((IFile)resource).getContents();
                        out.putNextEntry(new ZipEntry(path));
                        byte[] buffer = new byte[10240];
                        int i = in.read(buffer);
                        while (true) {
                            if (i < 0) {
                                out.closeEntry();
                            }
                            out.write(buffer, 0, i);
                            i = in.read(buffer);
                        }
                    }
                    catch (IOException e) {
                        new ErrorDialog(ExportWebappWizard.this.getShell(), "Error writing class file: " + path, e.getMessage(), (IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var6_9 = null;
                }
                try {}
                catch (IOException iOException) {
                    return false;
                }
                if (in == null) return false;
                in.close();
                return false;
            }
        };
        if (monitor.isCanceled()) {
            return false;
        }
        IResource[] members = this.applicationProject.getUnderlyingProject().getFolder("Web Services").members();
        int i4 = 0;
        while (i4 < members.length) {
            IFolder folder;
            if (monitor.isCanceled()) {
                return false;
            }
            if (members[i4].getType() == 2 && (folder = ((IFolder)members[i4]).getFolder(".classes")).exists()) {
                folder.accept(copyClassesVisitor);
                monitor.worked(1);
            }
            ++i4;
        }
        return !monitor.isCanceled();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        try {
            this.initializeWizard(selected);
        }
        catch (CoreException e) {
            new ErrorDialog(this.getShell(), "Error Exporting Application", e.getMessage(), e.getStatus(), 4).open();
            IllegalStateException ex = new IllegalStateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new SelectWARPage());
        if (!this.databases.isEmpty()) {
            this.addPage((IWizardPage)new ConfigureDatabasesPage());
        }
        if (!this.webServices.isEmpty()) {
            this.addPage((IWizardPage)new ConfigureWebServicesPage());
        }
        this.addPage((IWizardPage)new SelectIncludesPage());
    }

    public boolean canFinish() {
        return this.war != null;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    parent = ExportWebappWizard.access$10(ExportWebappWizard.this).getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    success = false;
                    out = null;
                    try {
                        try {
                            out = new ZipOutputStream(new FileOutputStream(ExportWebappWizard.access$10(ExportWebappWizard.this)));
                            success = ExportWebappWizard.access$11(ExportWebappWizard.this, monitor, out);
                        }
                        catch (FileNotFoundException e) {
                            new ErrorDialog(ExportWebappWizard.this.getShell(), "WAR file not found", e.getMessage(), (IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
                        }
                        catch (CoreException e) {
                            new ErrorDialog(ExportWebappWizard.this.getShell(), "Error exporting WAR", e.getMessage(), e.getStatus(), 4).open();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            new ErrorDialog(ExportWebappWizard.this.getShell(), "Unknown error", e.getMessage(), (IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
                        }
                        var6_10 = null;
                        ** GOTO lbl36
                    }
                    catch (Throwable var7_8) {
                        var6_9 = null;
                        try {
                            block18: {
                                block17: {
                                    try {
                                        if (out != null) {
                                            out.close();
                                        }
                                        break block17;
lbl36:
                                        // 1 sources

                                        ** try [egrp 2[TRYBLOCK] [8 : 231->248)] { 
lbl37:
                                        // 1 sources

                                        ** try [egrp 3[TRYBLOCK] [7 : 231->244)] { 
lbl38:
                                        // 1 sources

                                        if (out != null) {
                                            out.close();
                                        }
                                        break block18;
                                    }
                                    catch (IOException v0) {}
                                }
                                v1 = null;
                                ** GOTO lbl52
lbl46:
                                // 1 sources

                                catch (IOException v2) {}
                            }
                            v3 = null;
                            ** GOTO lbl59
                        }
                        catch (Throwable var9_11) {
                            v1 = null;
lbl52:
                            // 2 sources

                            var8_13 = v1;
                            if (success != false) throw var7_8;
                            ExportWebappWizard.access$10(ExportWebappWizard.this).delete();
                            throw var7_8;
                        }
                    }
lbl57:
                    // 1 sources

                    catch (Throwable var9_12) {
                        v3 = null;
lbl59:
                        // 2 sources

                        var8_14 = v3;
                        if (success != false) return;
                        ExportWebappWizard.access$10(ExportWebappWizard.this).delete();
                        return;
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.getShell(), "Error preparing WAR", e.getTargetException().getMessage(), (IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 1, e.getTargetException().getMessage(), e.getTargetException()), 4).open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error preparing WAR", e.getMessage(), (IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
        }
        return false;
    }

    static /* synthetic */ File access$10(ExportWebappWizard exportWebappWizard) {
        return exportWebappWizard.war;
    }

    static /* synthetic */ boolean access$11(ExportWebappWizard exportWebappWizard, IProgressMonitor iProgressMonitor, ZipOutputStream zipOutputStream) throws CoreException {
        return exportWebappWizard.writeWAR(iProgressMonitor, zipOutputStream);
    }

    private class ConfigureDatabasesPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        List databaseList;
        Combo typeCombo;
        Composite stackComposite;
        StackLayout stackLayout;
        Composite jndiComposite;
        Composite jdbcComposite;
        Text jndiUriText;
        Text jndiUsrText;
        Text jndiPwdText;
        Text jdbcDvrText;
        Text jdbcUrlText;
        Text jdbcUsrText;
        Text jdbcPwdText;

        ConfigureDatabasesPage() {
            super("Configure the application databases");
            this.databaseList = null;
            this.typeCombo = null;
            this.stackComposite = null;
            this.stackLayout = null;
            this.jndiComposite = null;
            this.jdbcComposite = null;
            this.jndiUriText = null;
            this.jndiUsrText = null;
            this.jndiPwdText = null;
            this.jdbcDvrText = null;
            this.jdbcUrlText = null;
            this.jdbcUsrText = null;
            this.jdbcPwdText = null;
            this.setTitle(this.getName());
        }

        void databaseSelectionChanged() {
            Properties props = (Properties)ExportWebappWizard.this.databases.get(this.databaseList.getItem(this.databaseList.getSelectionIndex()));
            String type = props.getProperty(ExportWebappWizard.DB_PROP_TYPE);
            if (ExportWebappWizard.DB_TYPE_JNDI.equals(type)) {
                this.typeCombo.select(0);
            } else {
                this.typeCombo.select(1);
            }
            this.typeSelectionChanged();
        }

        void typeSelectionChanged() {
            Properties props = (Properties)ExportWebappWizard.this.databases.get(this.databaseList.getItem(this.databaseList.getSelectionIndex()));
            switch (this.typeCombo.getSelectionIndex()) {
                case 0: {
                    props.setProperty(ExportWebappWizard.DB_PROP_TYPE, ExportWebappWizard.DB_TYPE_JNDI);
                    this.jndiUriText.setText(props.getProperty(ExportWebappWizard.DB_PROP_JNDI_URI));
                    this.jndiUsrText.setText(props.getProperty(ExportWebappWizard.DB_PROP_JNDI_USR));
                    this.jndiPwdText.setText(props.getProperty(ExportWebappWizard.DB_PROP_JNDI_PWD));
                    this.stackLayout.topControl = this.jndiComposite;
                    this.stackComposite.layout();
                    break;
                }
                case 1: {
                    props.setProperty(ExportWebappWizard.DB_PROP_TYPE, ExportWebappWizard.DB_TYPE_JDBC);
                    this.jdbcDvrText.setText(props.getProperty(ExportWebappWizard.DB_PROP_JDBC_DVR));
                    this.jdbcUrlText.setText(props.getProperty(ExportWebappWizard.DB_PROP_JDBC_URL));
                    this.jdbcUsrText.setText(props.getProperty(ExportWebappWizard.DB_PROP_JDBC_USR));
                    this.jdbcPwdText.setText(props.getProperty(ExportWebappWizard.DB_PROP_JDBC_PWD));
                    this.stackLayout.topControl = this.jdbcComposite;
                    this.stackComposite.layout();
                }
            }
        }

        public void createControl(Composite parent) {
            SashForm composite = new SashForm(parent, 256);
            this.databaseList = new List((Composite)composite, 2564);
            Iterator i = ExportWebappWizard.this.databases.keySet().iterator();
            while (i.hasNext()) {
                this.databaseList.add((String)i.next());
            }
            this.databaseList.addSelectionListener((SelectionListener)this);
            Composite configComposite = new Composite((Composite)composite, 0);
            configComposite.setLayout((Layout)new GridLayout(2, false));
            Label typeLabel = new Label(configComposite, 0);
            typeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            typeLabel.setText("Database lookup method:");
            this.typeCombo = new Combo(configComposite, 12);
            this.typeCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            this.typeCombo.add("JNDI Lookup");
            this.typeCombo.add("JDBC Driver");
            this.typeCombo.addSelectionListener((SelectionListener)this);
            new Label(configComposite, 258).setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.stackComposite = new Composite(configComposite, 0);
            this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.stackLayout = new StackLayout();
            this.stackComposite.setLayout((Layout)this.stackLayout);
            this.jndiComposite = new Composite(this.stackComposite, 0);
            this.jndiComposite.setLayout((Layout)new GridLayout(2, false));
            Label jndiUriLabel = new Label(this.jndiComposite, 0);
            jndiUriLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jndiUriLabel.setText("JNDI URI:");
            this.jndiUriText = new Text(this.jndiComposite, 2048);
            this.jndiUriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jndiUriText.addModifyListener((ModifyListener)this);
            Label jndiUsrLabel = new Label(this.jndiComposite, 0);
            jndiUsrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jndiUsrLabel.setText("User Name:");
            this.jndiUsrText = new Text(this.jndiComposite, 2048);
            this.jndiUsrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jndiUsrText.addModifyListener((ModifyListener)this);
            Label jndiPwdLabel = new Label(this.jndiComposite, 0);
            jndiPwdLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jndiPwdLabel.setText("Password:");
            this.jndiPwdText = new Text(this.jndiComposite, 2048);
            this.jndiPwdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jndiPwdText.addModifyListener((ModifyListener)this);
            this.jdbcComposite = new Composite(this.stackComposite, 0);
            this.jdbcComposite.setLayout((Layout)new GridLayout(2, false));
            Label jdbcDvrLabel = new Label(this.jdbcComposite, 0);
            jdbcDvrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jdbcDvrLabel.setText("JDBC Driver:");
            this.jdbcDvrText = new Text(this.jdbcComposite, 2048);
            this.jdbcDvrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jdbcDvrText.addModifyListener((ModifyListener)this);
            Label jdbcUrlLabel = new Label(this.jdbcComposite, 0);
            jdbcUrlLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jdbcUrlLabel.setText("JDBC URL:");
            this.jdbcUrlText = new Text(this.jdbcComposite, 2048);
            this.jdbcUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jdbcUrlText.addModifyListener((ModifyListener)this);
            Label jdbcUsrLabel = new Label(this.jdbcComposite, 0);
            jdbcUsrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jdbcUsrLabel.setText("User Name:");
            this.jdbcUsrText = new Text(this.jdbcComposite, 2048);
            this.jdbcUsrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jdbcUsrText.addModifyListener((ModifyListener)this);
            Label jdbcPwdLabel = new Label(this.jdbcComposite, 0);
            jdbcPwdLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jdbcPwdLabel.setText("Password:");
            this.jdbcPwdText = new Text(this.jdbcComposite, 2048);
            this.jdbcPwdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jdbcPwdText.addModifyListener((ModifyListener)this);
            this.setControl((Control)composite);
            this.databaseList.select(0);
            this.databaseSelectionChanged();
        }

        public void modifyText(ModifyEvent e) {
            Properties props = (Properties)ExportWebappWizard.this.databases.get(this.databaseList.getItem(this.databaseList.getSelectionIndex()));
            if (e.getSource() == this.jndiUriText) {
                props.setProperty(ExportWebappWizard.DB_PROP_JNDI_URI, this.jndiUriText.getText());
            } else if (e.getSource() == this.jndiUsrText) {
                props.setProperty(ExportWebappWizard.DB_PROP_JNDI_USR, this.jndiUsrText.getText());
            } else if (e.getSource() == this.jndiPwdText) {
                props.setProperty(ExportWebappWizard.DB_PROP_JNDI_PWD, this.jndiPwdText.getText());
            } else if (e.getSource() == this.jdbcDvrText) {
                props.setProperty(ExportWebappWizard.DB_PROP_JDBC_DVR, this.jdbcDvrText.getText());
            } else if (e.getSource() == this.jdbcUrlText) {
                props.setProperty(ExportWebappWizard.DB_PROP_JDBC_URL, this.jdbcUrlText.getText());
            } else if (e.getSource() == this.jdbcUsrText) {
                props.setProperty(ExportWebappWizard.DB_PROP_JDBC_USR, this.jdbcUsrText.getText());
            } else if (e.getSource() == this.jdbcPwdText) {
                props.setProperty(ExportWebappWizard.DB_PROP_JDBC_PWD, this.jdbcPwdText.getText());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == this.databaseList) {
                this.databaseSelectionChanged();
            } else if (e.getSource() == this.typeCombo) {
                this.typeSelectionChanged();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ConfigureWebServicesPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        List portList;
        Text endpointText;

        ConfigureWebServicesPage() {
            super("Configure the application web services");
            this.portList = null;
            this.endpointText = null;
            this.setTitle(this.getName());
        }

        void portSelectionChanged() {
            Properties props = (Properties)ExportWebappWizard.this.webServices.get(this.portList.getItem(this.portList.getSelectionIndex()));
            this.endpointText.setText(props.getProperty(ExportWebappWizard.WS_PROP_ENDPOINT));
        }

        public void createControl(Composite parent) {
            SashForm composite = new SashForm(parent, 256);
            this.portList = new List((Composite)composite, 2564);
            Iterator i = ExportWebappWizard.this.webServices.keySet().iterator();
            while (i.hasNext()) {
                this.portList.add((String)i.next());
            }
            this.portList.addSelectionListener((SelectionListener)this);
            Composite configComposite = new Composite((Composite)composite, 0);
            configComposite.setLayout((Layout)new GridLayout(2, false));
            Label endpointLabel = new Label(configComposite, 0);
            endpointLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            endpointLabel.setText("Endpoint Address:");
            this.endpointText = new Text(configComposite, 2048);
            this.endpointText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.endpointText.addModifyListener((ModifyListener)this);
            this.setControl((Control)composite);
            this.portList.select(0);
            this.portSelectionChanged();
        }

        public void modifyText(ModifyEvent e) {
            Properties props = (Properties)ExportWebappWizard.this.webServices.get(this.portList.getItem(this.portList.getSelectionIndex()));
            if (e.getSource() == this.endpointText) {
                props.setProperty(ExportWebappWizard.WS_PROP_ENDPOINT, this.endpointText.getText());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == this.portList) {
                this.portSelectionChanged();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class EmbeddedAxisJar
    extends EmbeddedJar {
        final File jar;

        EmbeddedAxisJar(File jar) {
            this.jar = jar;
            this.shouldBeEmbedded = true;
        }

        public String toString() {
            return "Axis: " + this.getFileName();
        }

        final boolean canBeEmbedded() {
            return true;
        }

        final String getFileName() {
            return this.jar.getName();
        }

        final InputStream openStream() throws CoreException {
            try {
                return new FileInputStream(this.jar);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
        }
    }

    private abstract class EmbeddedBundleJar
    extends EmbeddedJar {
        final Bundle bundle;
        final URL bundleUrl;

        EmbeddedBundleJar(Bundle bundle) {
            this.bundle = bundle;
            URL bundleUrl = null;
            if (bundle.getLocation().startsWith("update@") && bundle.getLocation().endsWith(".jar")) {
                try {
                    bundleUrl = new URL(ExportWebappWizard.this.installURL, bundle.getLocation().substring(7));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            this.bundleUrl = bundleUrl;
            this.shouldBeEmbedded = this.canBeEmbedded();
        }

        final boolean canBeEmbedded() {
            return this.bundleUrl != null;
        }

        final String getFileName() {
            return String.valueOf(this.bundle.getSymbolicName()) + "_" + this.bundle.getHeaders().get("Bundle-Version") + ".jar";
        }

        final InputStream openStream() throws CoreException {
            try {
                return this.bundleUrl.openStream();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
        }
    }

    private final class EmbeddedDependencyJar
    extends EmbeddedJar {
        final IFile jarFile;

        EmbeddedDependencyJar(IFile jarFile) {
            this.jarFile = jarFile;
        }

        boolean canBeEmbedded() {
            return this.jarFile.exists();
        }

        String getFileName() {
            return this.jarFile.getName();
        }

        InputStream openStream() throws CoreException {
            return this.jarFile.getContents();
        }

        public String toString() {
            return "Dependency: " + this.jarFile.getName();
        }
    }

    private final class EmbeddedFrameworkJar
    extends EmbeddedBundleJar {
        EmbeddedFrameworkJar(Bundle bundle) {
            super(bundle);
        }

        public String toString() {
            return (String)this.bundle.getHeaders().get("Bundle-Name");
        }
    }

    private abstract class EmbeddedJar {
        boolean shouldBeEmbedded = true;

        private EmbeddedJar() {
        }

        abstract boolean canBeEmbedded();

        abstract String getFileName();

        abstract InputStream openStream() throws CoreException;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void embed(ZipOutputStream out) throws CoreException {
            if (!this.canBeEmbedded()) {
                return;
            }
            if (!this.shouldBeEmbedded) {
                return;
            }
            InputStream in = null;
            try {
                try {
                    in = this.openStream();
                    out.putNextEntry(new ZipEntry("WEB-INF/lib/" + this.getFileName()));
                    byte[] buffer = new byte[10240];
                    int i = in.read(buffer);
                    while (true) {
                        block11: {
                            if (i >= 0) break block11;
                            out.closeEntry();
                            break;
                        }
                        out.write(buffer, 0, i);
                        i = in.read(buffer);
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, ApplicationUIPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_8 = null;
            }
            try {}
            catch (IOException iOException) {
                return;
            }
            if (in == null) return;
            in.close();
        }
    }

    private final class EmbeddedLanguagePackJar
    extends EmbeddedBundleJar {
        final String language;

        EmbeddedLanguagePackJar(Bundle bundle, String languageCode) {
            super(bundle);
            String language = null;
            String country = null;
            String variant = null;
            StringTokenizer st = new StringTokenizer(languageCode, "-_");
            if (st.hasMoreTokens()) {
                language = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                country = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                variant = st.nextToken();
            }
            this.language = language == null ? Locale.getDefault().getDisplayName() : (country == null ? new Locale(language).getDisplayName() : (variant == null ? new Locale(language, country).getDisplayName() : new Locale(language, country, variant).getDisplayName()));
        }

        public String toString() {
            return "Language Pack for " + this.language;
        }
    }

    private final class EmbeddedModuleJar
    extends EmbeddedBundleJar {
        final String vendor;
        final String moduleGroup;
        final String version;

        EmbeddedModuleJar(Bundle bundle, String vendor, String moduleGroup, String version) {
            super(bundle);
            this.vendor = vendor;
            this.moduleGroup = moduleGroup;
            this.version = version;
        }

        public String toString() {
            return String.valueOf(this.moduleGroup) + " module group version " + this.version + " from " + this.vendor;
        }
    }

    private class SelectIncludesPage
    extends WizardPage
    implements ICheckStateListener {
        private CheckboxTableViewer viewer;

        SelectIncludesPage() {
            super("Select the JAR files to include");
            this.setTitle(this.getName());
        }

        public void createControl(Composite parent) {
            this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            LinkedList list = new LinkedList();
            list.addAll(ExportWebappWizard.this.frameworkBundles.values());
            list.addAll(ExportWebappWizard.this.axisJars.values());
            list.addAll(ExportWebappWizard.this.languageBundles.values());
            list.addAll(ExportWebappWizard.this.moduleBundles.values());
            list.addAll(ExportWebappWizard.this.dependencies.values());
            this.viewer.add(list.toArray());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                EmbeddedJar jar = (EmbeddedJar)i.next();
                if (jar.canBeEmbedded()) {
                    this.viewer.setChecked((Object)jar, true);
                    continue;
                }
                this.viewer.setGrayed((Object)jar, true);
            }
            this.viewer.addCheckStateListener((ICheckStateListener)this);
            this.setControl((Control)this.viewer.getTable());
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            EmbeddedJar jar = (EmbeddedJar)event.getElement();
            if (!event.getChecked()) {
                jar.shouldBeEmbedded = false;
            } else if (jar.canBeEmbedded()) {
                jar.shouldBeEmbedded = true;
            } else {
                this.viewer.setChecked((Object)jar, false);
            }
        }
    }

    private class SelectWARPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        Text pathText;

        SelectWARPage() {
            super("Select a WAR file");
            this.pathText = null;
            this.setTitle(this.getName());
        }

        void evaluateState() {
            String msg = null;
            String path = this.pathText.getText();
            if (path == null || path.length() == 0) {
                msg = "Select a WAR file to export to.";
            } else if (new File(path).isDirectory()) {
                msg = "Select a file, not a directory.";
            }
            if (msg == null) {
                ExportWebappWizard.this.war = new File(path);
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                ExportWebappWizard.this.war = null;
                this.setErrorMessage(msg);
                this.setPageComplete(false);
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            Label lbl = new Label(composite, 0);
            lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            lbl.setText("WAR file:");
            this.pathText = new Text(composite, 2048);
            this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.pathText.addModifyListener((ModifyListener)this);
            Button browseButton = new Button(composite, 8);
            browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            browseButton.setText("Browse...");
            browseButton.addSelectionListener((SelectionListener)this);
            this.setControl((Control)composite);
            this.pathText.setFocus();
            this.evaluateState();
        }

        public void modifyText(ModifyEvent e) {
            this.evaluateState();
        }

        public void widgetSelected(SelectionEvent e) {
            String path = new FileDialog(this.getShell()).open();
            if (path == null) {
                return;
            }
            this.pathText.setText(path);
            this.evaluateState();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class XMLWriter {
        final PrintStream out;
        int depth = 0;

        XMLWriter(OutputStream out) {
            this.out = new PrintStream(out);
            this.out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            this.out.println();
            this.out.println("<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" ");
            this.out.println("                         \"http://java.sun.com/dtd/web-app_2_3.dtd\">");
            this.out.println();
        }

        void startElement(String name) {
            int i = 0;
            while (i < this.depth) {
                this.out.print("\t");
                ++i;
            }
            this.out.println("<" + name + ">");
            ++this.depth;
        }

        void writeElement(String name, String value) {
            int i = 0;
            while (i < this.depth) {
                this.out.print("\t");
                ++i;
            }
            this.out.print("<" + name + ">");
            this.out.print(value);
            this.out.println("</" + name + ">");
        }

        void endElement(String name) {
            --this.depth;
            int i = 0;
            while (i < this.depth) {
                this.out.print("\t");
                ++i;
            }
            this.out.println("</" + name + ">");
        }

        void close() {
            this.out.flush();
        }
    }
}

