/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.wizards;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.ide.IDE;

public class NewGRXMLWizard
extends Wizard
implements INewWizard {
    private final NewGRXMLWizardPage page = new NewGRXMLWizardPage();
    private ISelection selection;

    public NewGRXMLWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.containerText.getText();
        final String fileName = this.page.fileText.getText();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewGRXMLWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists()) throw this.newCoreException("Container \"" + containerName + "\" does not exist.");
        if (!(resource instanceof IContainer)) {
            throw this.newCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        InputStream input = null;
        try {
            input = ((Object)((Object)this)).getClass().getResourceAsStream("grammar.grxml");
            if (file.exists()) {
                file.setContents(input, true, true, monitor);
            } else {
                file.create(input, true, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (input != null) {
            input.close();
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private CoreException newCoreException(String message) throws CoreException {
        return new CoreException((IStatus)new Status(4, "org.eclipse.vtp.desktop.ui.app", 0, message, null));
    }

    private class NewGRXMLWizardPage
    extends WizardPage {
        Text containerText;
        Text fileText;

        NewGRXMLWizardPage() {
            super("wizardPage");
            this.setTitle("New GRXML File");
            this.setDescription("This wizard creates a new empty GRXML file.");
        }

        public void createControl(Composite parent) {
            Object obj;
            IStructuredSelection ssel;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            layout.numColumns = 3;
            layout.verticalSpacing = 9;
            Label label = new Label(composite, 0);
            label.setText("&Container:");
            this.containerText = new Text(composite, 2052);
            GridData gd = new GridData(768);
            this.containerText.setLayoutData((Object)gd);
            this.containerText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ NewGRXMLWizardPage this$1;
                {
                    this.this$1 = newGRXMLWizardPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.dialogChanged();
                }
            });
            Button button = new Button(composite, 8);
            button.setText("Browse...");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ NewGRXMLWizardPage this$1;
                {
                    this.this$1 = newGRXMLWizardPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.handleBrowse();
                }
            });
            label = new Label(composite, 0);
            label.setText("&File name:");
            this.fileText = new Text(composite, 2052);
            gd = new GridData(768);
            this.fileText.setLayoutData((Object)gd);
            this.fileText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ NewGRXMLWizardPage this$1;
                {
                    this.this$1 = newGRXMLWizardPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.dialogChanged();
                }
            });
            if (NewGRXMLWizard.this.selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)NewGRXMLWizard.this.selection).size() == 1 && (obj = ssel.getFirstElement()) instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
            this.fileText.setText("grammar.grxml");
            this.dialogChanged();
            this.setControl((Control)composite);
        }

        void handleBrowse() {
            Object[] result;
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                this.containerText.setText(((Path)result[0]).toString());
            }
        }

        void dialogChanged() {
            String ext;
            IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.containerText.getText()));
            String fileName = this.fileText.getText();
            if (this.containerText.getText().length() == 0) {
                this.updateStatus("File container must be specified");
                return;
            }
            if (container == null || (container.getType() & 6) == 0) {
                this.updateStatus("File container must exist");
                return;
            }
            if (!container.isAccessible()) {
                this.updateStatus("Project must be writable");
                return;
            }
            if (fileName.length() == 0) {
                this.updateStatus("File name must be specified");
                return;
            }
            if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
                this.updateStatus("File name must be valid");
                return;
            }
            int dotLoc = fileName.lastIndexOf(46);
            if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("grxml")) {
                this.updateStatus("File extension must be \"grxml\"");
                return;
            }
            this.updateStatus(null);
        }

        void updateStatus(String message) {
            this.setErrorMessage(message);
            this.setPageComplete(message == null);
        }
    }
}

