/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.api;

import java.math.BigDecimal;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.BObjectException;
import org.eclipse.vtp.framework.api.BObjectType;

public class BDecimal
extends BObject {
    BigDecimal value;

    protected BDecimal(BObjectType type, String name) {
        super(type, name);
    }

    public BDecimal(String name) {
        this(new BObjectType("Decimal", false, true), name);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object obj) {
        if (obj instanceof BigDecimal) {
            this.value = (BigDecimal)obj;
        } else {
            String svalue = obj.toString();
            try {
                this.value = new BigDecimal(svalue);
            }
            catch (Exception ex) {
                throw new BObjectException("Could not convert " + obj.getClass() + " to a number", ex);
            }
        }
    }

    public boolean compare(Object obj, int comparison) {
        BigDecimal cvalue;
        if (obj instanceof Double) {
            cvalue = new BigDecimal((Double)obj);
        } else {
            String svalue = obj.toString();
            try {
                cvalue = new BigDecimal(svalue);
            }
            catch (Exception exception) {
                return false;
            }
        }
        switch (comparison) {
            case 0: {
                return this.value.equals(cvalue);
            }
            case 1: {
                return !this.value.equals(cvalue);
            }
            case 2: {
                return this.value.compareTo(cvalue) < 0;
            }
            case 3: {
                return this.value.compareTo(cvalue) <= 0;
            }
            case 4: {
                return this.value.compareTo(cvalue) > 0;
            }
            case 5: {
                return this.value.compareTo(cvalue) >= 0;
            }
        }
        return false;
    }

    public void addField(BObject field) {
        throw new BObjectException("Unsupported operation");
    }
}

