/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.eclipse.vtp.framework.common.configurations.ExitConfiguration;
import org.eclipse.vtp.framework.common.controller.IController;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;

public class ExitAction
implements IAction {
    protected final IActionContext context;
    protected final IController controller;
    protected final ExitConfiguration configuration;
    protected final AssignmentConfiguration[] assignments;

    public ExitAction(IActionContext context, IController controller, ExitConfiguration configuration, AssignmentConfiguration[] assignments) {
        this.context = context;
        this.controller = controller;
        this.configuration = configuration;
        this.assignments = assignments;
    }

    public IActionResult execute() {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "exit");
            ((Dictionary)props).put("exit.path", String.valueOf(this.configuration.getValue()));
            this.context.report(3, "Exiting via path \"" + this.configuration.getValue() + "\".", props);
            if (this.controller.createExit(this.configuration, this.assignments).enqueue()) {
                return this.context.createResult("abort");
            }
        }
        catch (Exception e) {
            return this.context.createResult("error.exit", (Throwable)e);
        }
        return this.context.createResult("error.exit");
    }
}

