/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.configurations.DispatchConfiguration;
import org.eclipse.vtp.framework.common.controller.IController;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;

public class ForwardAction
implements IAction {
    private final IActionContext context;
    private final IController controller;
    private final DispatchConfiguration configuration;

    public ForwardAction(IActionContext context, IController controller, DispatchConfiguration configuration) {
        this.context = context;
        this.controller = controller;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "forward");
            ((Dictionary)props).put("forward.target", String.valueOf(this.configuration.getTargetProcessURI()));
            this.context.report(3, "Forwarding to \"" + this.configuration.getTargetProcessURI() + "\".", props);
            if (this.controller.createForward(this.configuration).enqueue()) {
                return this.context.createResult("abort");
            }
        }
        catch (Exception e) {
            return this.context.createResult("error.forward", (Throwable)e);
        }
        return this.context.createResult("error.forward");
    }
}

