/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.common.configurations.ScriptConfiguration;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;

public class ScriptedAction
implements IAction {
    private final IActionContext context;
    private final IScriptingEngine engine;
    private final String script;

    public ScriptedAction(IActionContext context, IScriptingService scriptingService, ScriptConfiguration configuration) {
        this.context = context;
        this.engine = scriptingService.createScriptingEngine(configuration.getScriptingLanguage());
        this.script = configuration.getScript();
    }

    public IActionResult execute() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event", "script");
        this.context.report(3, "Executing script.", props);
        this.context.info("Executing script...");
        try {
            this.engine.execute(this.script);
        }
        catch (Exception e) {
            return this.context.createResult("error.script", (Throwable)e);
        }
        props = new Hashtable();
        this.context.report(3, "Script completed.", props);
        return this.context.createResult("default");
    }
}

