/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.common.commands.ControllerCommand;
import org.eclipse.vtp.framework.common.commands.IControllerCommandVisitor;

public final class ExitCommand
extends ControllerCommand {
    private String exitValue = null;
    private final Map variables = new HashMap();

    public String getExitValue() {
        return this.exitValue;
    }

    public void setExitValue(String exitValue) {
        this.exitValue = exitValue;
    }

    public String[] getVariableNames() {
        return this.variables.keySet().toArray(new String[this.variables.size()]);
    }

    public Object getVariableValue(String name) {
        if (name == null) {
            return null;
        }
        return this.variables.get(name);
    }

    public void setVariableValues(String name, Object value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this.variables.remove(name);
        } else {
            this.variables.put(name, value);
        }
    }

    Object accept(IControllerCommandVisitor visitor) {
        return visitor.visitExit(this);
    }

    public Object exportContents() {
        ArrayList<String> variables = new ArrayList<String>(this.variables.size() * 2);
        for (Map.Entry entry : this.variables.entrySet()) {
            variables.add((String)entry.getKey());
            variables.add((String)entry.getValue());
        }
        return new Object[]{this.exitValue, variables.toArray()};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.exitValue = (String)array[0];
        this.variables.clear();
        Object[] variables = (Object[])array[1];
        int i = 0;
        while (i < variables.length) {
            this.variables.put(variables[i], variables[i + 1]);
            i += 2;
        }
    }
}

