/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.common.commands.ControllerCommand;
import org.eclipse.vtp.framework.common.commands.IControllerCommandVisitor;

public final class ForwardCommand
extends ControllerCommand {
    private String targetProcessURI = null;
    private final Map variableMappings = new HashMap();

    public String getTargetProcessURI() {
        return this.targetProcessURI;
    }

    public void setTargetProcessURI(String targetProcessURI) {
        this.targetProcessURI = targetProcessURI;
    }

    public String[] getVariableNames() {
        return this.variableMappings.keySet().toArray(new String[this.variableMappings.size()]);
    }

    public String getgVariableValue(String targetVariableName) {
        if (targetVariableName == null) {
            return null;
        }
        return (String)this.variableMappings.get(targetVariableName);
    }

    public void setVariableValue(String targetVariableName, String localVariableName) {
        if (targetVariableName == null) {
            return;
        }
        if (localVariableName == null) {
            this.variableMappings.remove(targetVariableName);
        } else {
            this.variableMappings.put(targetVariableName, localVariableName);
        }
    }

    Object accept(IControllerCommandVisitor visitor) {
        return visitor.visitForward(this);
    }

    public Object exportContents() {
        ArrayList<String> variableMappings = new ArrayList<String>(this.variableMappings.size() * 2);
        for (Map.Entry entry : this.variableMappings.entrySet()) {
            variableMappings.add((String)entry.getKey());
            variableMappings.add((String)entry.getValue());
        }
        return new Object[]{this.targetProcessURI, variableMappings.toArray(new String[variableMappings.size()])};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.targetProcessURI = (String)array[0];
        this.variableMappings.clear();
        String[] variableMappings = (String[])array[1];
        int i = 0;
        while (i < variableMappings.length) {
            this.variableMappings.put(variableMappings[i], variableMappings[i + 1]);
            i += 2;
        }
    }
}

