/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.common.commands.ControllerCommand;
import org.eclipse.vtp.framework.common.commands.IControllerCommandVisitor;

public final class IncludeCommand
extends ControllerCommand {
    private String targetProcessURI = null;
    private final Map variableMappings = new HashMap();
    private final Map outgoingData = new HashMap();
    private final Map parameters = new HashMap();

    public String getTargetProcessURI() {
        return this.targetProcessURI;
    }

    public void setTargetProcessURI(String targetProcessURI) {
        this.targetProcessURI = targetProcessURI;
    }

    public String[] getVariableNames() {
        return this.variableMappings.keySet().toArray(new String[this.variableMappings.size()]);
    }

    public String getVariableValue(String targetVariableName) {
        if (targetVariableName == null) {
            return null;
        }
        return (String)this.variableMappings.get(targetVariableName);
    }

    public void setVariableValue(String targetVariableName, String localVariableName) {
        if (targetVariableName == null) {
            return;
        }
        if (localVariableName == null) {
            this.variableMappings.remove(targetVariableName);
        } else {
            this.variableMappings.put(targetVariableName, localVariableName);
        }
    }

    public String[] getOutgoingPaths() {
        return this.outgoingData.keySet().toArray(new String[this.outgoingData.size()]);
    }

    public String[] getOutgoingDataNames(String path) {
        Map map = (Map)this.outgoingData.get(path);
        if (map == null) {
            return new String[0];
        }
        return map.keySet().toArray(new String[map.size()]);
    }

    public String getOutgoingDataValue(String path, String name) {
        Map map = (Map)this.outgoingData.get(path);
        if (map == null) {
            return null;
        }
        return (String)map.get(name);
    }

    public void setOutgoingDataValue(String path, String name, String value) {
        if (path == null || name == null) {
            return;
        }
        HashMap<String, String> map = (HashMap<String, String>)this.outgoingData.get(path);
        if (map == null) {
            if (value == null) {
                return;
            }
            map = new HashMap<String, String>();
            this.outgoingData.put(path, map);
        }
        if (value == null) {
            map.remove(name);
            if (map.isEmpty()) {
                this.outgoingData.remove(path);
            }
        } else {
            map.put(name, value);
        }
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        List list = (List)this.parameters.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public void setParameterValues(String name, String[] values) {
        if (name == null) {
            return;
        }
        if (values == null) {
            this.parameters.remove(name);
        } else {
            LinkedList<String> list = (LinkedList<String>)this.parameters.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.parameters.put(name, list);
            } else {
                list.clear();
            }
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    list.add(values[i]);
                }
                ++i;
            }
        }
    }

    Object accept(IControllerCommandVisitor visitor) {
        return visitor.visitInclude(this);
    }

    public Object exportContents() {
        ArrayList<String> variableMappings = new ArrayList<String>(this.variableMappings.size() * 2);
        for (Map.Entry entry : this.variableMappings.entrySet()) {
            variableMappings.add((String)entry.getKey());
            variableMappings.add((String)entry.getValue());
        }
        ArrayList<Object> outgoingData = new ArrayList<Object>(this.outgoingData.size() * 2);
        for (Map.Entry entry : this.outgoingData.entrySet()) {
            outgoingData.add((String)entry.getKey());
            Map map = (Map)entry.getValue();
            ArrayList<Object> entryData = new ArrayList<Object>(map.size() * 2);
            for (Map.Entry e : map.entrySet()) {
                entryData.add(e.getKey());
                entryData.add(e.getValue());
            }
            outgoingData.add(entryData.toArray());
        }
        ArrayList<String> parameters = new ArrayList<String>(this.parameters.size() * 2);
        for (Map.Entry entry : this.parameters.entrySet()) {
            parameters.add((String)entry.getKey());
            parameters.add((String)entry.getValue());
        }
        return new Object[]{this.targetProcessURI, variableMappings.toArray(new String[variableMappings.size()]), outgoingData.toArray(), parameters.toArray(new String[parameters.size()])};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.targetProcessURI = (String)array[0];
        this.variableMappings.clear();
        String[] variableMappings = (String[])array[1];
        int i = 0;
        while (i < variableMappings.length) {
            this.variableMappings.put(variableMappings[i], variableMappings[i + 1]);
            i += 2;
        }
        this.outgoingData.clear();
        Object[] outgoingData = (Object[])array[2];
        int i2 = 0;
        while (i2 < outgoingData.length) {
            String path = (String)outgoingData[i2];
            Object[] entries = (Object[])outgoingData[i2 + 1];
            int j = 0;
            while (j < entries.length) {
                this.setOutgoingDataValue(path, (String)entries[i2], (String)entries[i2 + 1]);
                j += 2;
            }
            i2 += 2;
        }
        this.parameters.clear();
        String[] parameters = (String[])array[3];
        int i3 = 0;
        while (i3 < parameters.length) {
            this.parameters.put(parameters[i3], parameters[i3 + 1]);
            i3 += 2;
        }
    }
}

