/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.configurations;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.vtp.framework.common.configurations.CommonConstants;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BrandConfiguration
implements IConfiguration,
CommonConstants {
    private String name = "";
    private final Set children = new HashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public BrandConfiguration[] getChildren() {
        return this.children.toArray(new BrandConfiguration[this.children.size()]);
    }

    public void addChild(BrandConfiguration child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
    }

    public void removeChild(BrandConfiguration child) {
        this.children.remove(child);
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        this.children.clear();
        NodeList list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/common/configurations", "brand");
        int i = 0;
        while (i < list.getLength()) {
            BrandConfiguration child = new BrandConfiguration();
            child.load((Element)list.item(i));
            this.children.add(child);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        if (!this.children.isEmpty()) {
            String brandName = "brand";
            String prefix = configurationElement.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                brandName = String.valueOf(prefix) + ":" + brandName;
            }
            for (BrandConfiguration child : this.children) {
                Element childElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", brandName);
                child.save(childElement);
                configurationElement.appendChild(childElement);
            }
        }
    }
}

