/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandRegistry;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.configurations.BrandConfiguration;
import org.eclipse.vtp.framework.common.support.ScriptableArray;

public class BrandRegistry
implements IBrandRegistry,
IScriptable {
    private final Brand defaultBrand;
    private final Map brandsByName;

    public BrandRegistry(BrandConfiguration configuration) {
        this.defaultBrand = new Brand(configuration, null);
        HashMap<String, Brand> brandsByName = new HashMap<String, Brand>();
        LinkedList<Brand> toIndex = new LinkedList<Brand>();
        toIndex.add(this.defaultBrand);
        while (!toIndex.isEmpty()) {
            Brand brand = (Brand)toIndex.removeFirst();
            brandsByName.put(brand.getName(), brand);
            int i = 0;
            while (i < brand.children.length) {
                toIndex.addLast(brand.children[i]);
                ++i;
            }
        }
        this.brandsByName = Collections.unmodifiableMap(new HashMap(brandsByName));
    }

    public IBrand getDefaultBrand() {
        return this.defaultBrand;
    }

    public IBrand getBrand(String name) {
        return (IBrand)this.brandsByName.get(name);
    }

    public final String getName() {
        return "Brands";
    }

    public boolean hasValue() {
        return false;
    }

    public Object toValue() {
        return null;
    }

    public final String[] getFunctionNames() {
        return new String[0];
    }

    public final Object invokeFunction(String name, Object[] arguments) {
        return null;
    }

    public final boolean hasItem(int index) {
        return false;
    }

    public final boolean hasEntry(String name) {
        return this.brandsByName.containsKey(name);
    }

    public final Object getItem(int index) {
        return null;
    }

    public final Object getEntry(String name) {
        return this.brandsByName.get(name);
    }

    public final boolean setItem(int index, Object value) {
        return false;
    }

    public final boolean setEntry(String name, Object value) {
        return false;
    }

    public final boolean clearItem(int index) {
        return false;
    }

    public final boolean clearEntry(String name) {
        return false;
    }

    private static final class Brand
    implements IBrand,
    IScriptable {
        final String name;
        final Brand parent;
        final Brand[] children;
        final ScriptableArray childArray;

        Brand(BrandConfiguration configuration, Brand parent) {
            this.name = configuration.getName();
            this.parent = parent;
            BrandConfiguration[] childConfigss = configuration.getChildren();
            if (childConfigss != null) {
                this.children = new Brand[childConfigss.length];
                int i = 0;
                while (i < childConfigss.length) {
                    this.children[i] = new Brand(childConfigss[i], this);
                    ++i;
                }
            } else {
                this.children = new Brand[0];
            }
            this.childArray = new ScriptableArray("children", this.children);
        }

        public boolean isDefault() {
            return this.parent == null;
        }

        public String getName() {
            return this.name;
        }

        public IBrand getParentBrand() {
            return this.parent;
        }

        public IBrand[] getChildBrands() {
            IBrand[] brands = new IBrand[this.children.length];
            System.arraycopy(this.children, 0, brands, 0, this.children.length);
            return brands;
        }

        public boolean hasValue() {
            return true;
        }

        public Object toValue() {
            return this.name;
        }

        public String[] getFunctionNames() {
            return new String[0];
        }

        public Object invokeFunction(String name, Object[] arguments) {
            return null;
        }

        public boolean hasItem(int index) {
            return false;
        }

        public boolean hasEntry(String name) {
            return "name".equals(name) || "parent".equals(name) || "children".equals(name);
        }

        public Object getItem(int index) {
            return null;
        }

        public Object getEntry(String name) {
            if ("name".equals(name)) {
                return name;
            }
            if ("parent".equals(name)) {
                return this.parent;
            }
            if ("children".equals(name)) {
                return this.childArray;
            }
            return null;
        }

        public boolean setItem(int index, Object value) {
            return false;
        }

        public boolean setEntry(String name, Object value) {
            return false;
        }

        public boolean clearItem(int index) {
            return false;
        }

        public boolean clearEntry(String name) {
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

